<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_model extends CI_Model {


    /*Commom Fetch*/
function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
    return $query->result_array();
	 
}
/*Commom Fetch*/

/*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
    $id = $this->db->insert_id();
    return $id;
} 
/*common insert */
/*commonpermanent delete */
public function common_permanent_delete($table,$data)
{
    $this->db->where($data);
$this->db->delete($table);
}
/*commonpermanent delete */
/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
    $id = $this->db->insert_id();
   return $id;
   // return $this->db->last_query();
}
/*common update */

/*fetch parent childs details*/
public function get_parent_childs_details($mobile)
{
    $this->db->select('students.*,schools_info.school_name');
    $this->db->from('students');
    $this->db->join('schools_info','schools_info.school_id = students.school_id','left');
    $this->db->where('students.delete_status',1);
    $this->db->group_start();
    $this->db->or_where('students.father_mobile',$mobile);
    $this->db->or_where('students.mother_mobile',$mobile);
    $this->db->or_where('students.guardian_mobile',$mobile);
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

/*fetch child details*/
public function get_child_profile($child_id)
{
    $this->db->select('students.*,class.class_name, IFNULL(students.father_dob, "") AS father_dob, IFNULL(students.mother_dob, "") AS mother_dob ');
    $this->db->from('students');
    $this->db->join('class','class.id = students.class_id','left');
   // $this->db->where('students.delete_status',1);
    $this->db->or_where('students.id',$child_id);
    $query= $this->db->get(); 
    return $query->result();
}
/*fetch parent sent messages*/
public function get_parent_sent_messages($child_id,$mobile,$sent_message_id)
{
    $no = "no name";
    $this->db->select("parent_messages.*,DATE_FORMAT(parent_messages.date,'%d-%m-%Y') as date,TIME_FORMAT(parent_messages.date,'%h:%i %p') as time,

    
    CASE 
        WHEN students.father_mobile = '$mobile' THEN students.father_name 
        WHEN students.mother_mobile = '$mobile' THEN students.mother_name 
        ELSE '$no' 
    END AS parent_name,
    students.student_name
    
    ");
    $this->db->from("parent_messages");
    $this->db->join("students","students.id = parent_messages.student_id","left");
   // $this->db->where('students.delete_status',1);
    $this->db->where("parent_messages.student_id",$child_id);
    if(!empty($sent_message_id)){
        $this->db->where("parent_messages.id",$sent_message_id);
    }
    $this->db->order_by('parent_messages.id','desc');
    $query= $this->db->get(); 
    return $query->result();
}
/*fetch parent inbox messages*/
public function get_parent_inbox_messages($child_id,$mobile,$inbox_message_id)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    students.student_name,
    IFNULL(parent_read_messages.read_message, '') AS read_message, 
    IFNULL(parent_read_messages.starred_message, '') AS starred_message, 
    IFNULL(parent_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("messages");
    $this->db->join("students","students.id = $child_id","left");
    $this->db->join("parent_read_messages","parent_read_messages.student_id = students.id AND 
    parent_read_messages.message_id = messages.id AND parent_read_messages.message_type = 'school_admin' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    if(!empty($inbox_message_id)){
        $this->db->where("messages.id",$inbox_message_id);
    }
   $this->db->where("FIND_IN_SET($child_id, messages.to_student) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("messages.date <=",date('Y-m-d'));
   $this->db->order_by("messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

/*fetch parent inbox messages*/
public function get_parent_inbox_messages_homepage($child_id,$mobile)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    students.student_name,
    IFNULL(parent_read_messages.read_message, '') AS read_message, 
    IFNULL(parent_read_messages.starred_message, '') AS starred_message, 
    IFNULL(parent_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("messages");
    $this->db->join("students","students.id = $child_id","left");
    $this->db->join("parent_read_messages","parent_read_messages.student_id = students.id AND 
    parent_read_messages.message_id = messages.id AND parent_read_messages.message_type = 'school_admin' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
   $this->db->where("FIND_IN_SET($child_id, messages.to_student) >", 0, FALSE); 
   $this->db->where("messages.date <=",date('Y-m-d'));
   // echo $this->db->last_query();exit;
   $this->db->order_by("messages.id","desc");
   $this->db->limit("2");
    $query= $this->db->get(); 
    return $query->result_array();
}

/*fetch search parent inbox messages*/
public function get_parent_search_inbox_messages($child_id,$mobile,$search_subject)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    students.student_name,
    IFNULL(parent_read_messages.read_message, '') AS read_message, 
    IFNULL(parent_read_messages.starred_message, '') AS starred_message, 
    IFNULL(parent_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("messages");
    $this->db->join("students","students.id = $child_id","left");
    $this->db->join("parent_read_messages","parent_read_messages.student_id = students.id AND 
    parent_read_messages.message_id = messages.id AND parent_read_messages.message_type = 'school_admin' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    if(!empty($search_subject)){
        //$this->db->where("messages.id",$inbox_message_id);
       $this->db->like('messages.subject', $search_subject);
    }
   $this->db->where("FIND_IN_SET($child_id, messages.to_student) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
    $this->db->where("messages.date <=",date('Y-m-d'));
   $this->db->order_by("messages.id","desc");
  
    $query= $this->db->get(); 
    return $query->result_array();
}
/*fetch student album details*/
public function get_parent_child_albums($child_id,$album_type,$album_id)
{
    $this->db->select("albums.id,albums.title,albums.album_type,albums.school_id,albums.type");
    $this->db->from("albums");
    $this->db->join("students","students.id = $child_id","left");
    if($album_type == "all"){
        $this->db->where("students.id",$child_id);
    $this->db->group_start(); 
 //   $this->db->where("albums.type","Private");
    $this->db->where("FIND_IN_SET(students.class_id, albums.classes) >", 0, FALSE); 
    $this->db->or_where("albums.type","Public");
    $this->db->group_end();
    }else if($album_type ==  "mychild"){
        $this->db->where("students.id",$child_id);
    $this->db->group_start(); 
 //   $this->db->where("albums.type","Private");
    $this->db->where("FIND_IN_SET(students.class_id, albums.classes) >", 0, FALSE); 
    $this->db->group_end();
    }else if($album_type ==  ""){
      $this->db->where("albums.id",$album_id);   
    }
    
    
 //  $this->db->where("students.school_id","albums.school_id");
  // $this->db->where("students.id",$child_id);
 //   $this->db->group_start(); 
 //   $this->db->where("albums.type","Private");
  //  $this->db->where("FIND_IN_SET(students.class_id, albums.classes) >", 0, FALSE); 
  //  $this->db->or_where("albums.type","Public");
  //  $this->db->group_end();
     $this->db->order_by('albums.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}

/*fetch student album details for home page*/
public function get_parent_child_albums_for_homepage($child_id,$album_type)
{
    $this->db->select("albums.id,albums.title,albums.album_type,albums.school_id,albums.type");
    $this->db->from("albums");
    $this->db->join("students","students.id = $child_id","left");
    if($album_type == "all"){
        $this->db->where("students.id",$child_id);
    $this->db->group_start(); 
 //   $this->db->where("albums.type","Private");
    $this->db->where("FIND_IN_SET(students.class_id, albums.classes) >", 0, FALSE); 
    $this->db->or_where("albums.type","Public");
    $this->db->group_end();
    }else if($album_type ==  "mychild"){
        $this->db->where("students.id",$child_id);
    $this->db->group_start(); 
 //   $this->db->where("albums.type","Private");
    $this->db->where("FIND_IN_SET(students.class_id, albums.classes) >", 0, FALSE); 
    $this->db->group_end();
    }
    $this->db->order_by('albums.id','desc');
    $this->db->limit("2");
    $query = $this->db->get();
    return $query->result_array();
}
public function fetch_album_content_for_homepage($album_id)
{
    $this->db->select("album_content.*", FALSE);
    $this->db->from("album_content");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('album_content.album_id', $album_id);
    $this->db->limit("1");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function fetch_album_content_for_all($album_id)
{
    $this->db->select("album_content.*", FALSE);
    $this->db->from("album_content");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('album_content.album_id', $album_id);
    $this->db->limit("3");
    $query= $this->db->get(); 
    return $query->result_array();
}



/*fetch child planner */
public function get_parent_child_palnner($child_id,$date,$meal_type)
{
    $this->db->select("DISTINCT school_meal_planner.*,DATE_FORMAT(school_meal_planner.date,'%d') as date,
    DATE_FORMAT(school_meal_planner.date,'%a ') as day,", FALSE);
    $this->db->from("school_meal_planner");
    $this->db->join('students', 'students.school_id = school_meal_planner.school_id', 'inner');
    $this->db->where("school_meal_planner.meal_type",$meal_type);
    $this->db->where('students.id', $child_id);
$this->db->where("MONTH(school_meal_planner.date) = MONTH('$date')", NULL, FALSE);
$this->db->where("YEAR(school_meal_planner.date) = YEAR('$date')", NULL, FALSE);

   // $this->db->where("DATE_FORMAT(school_meal_planner.date, '%Y-%m') = DATE_FORMAT('$date', '%Y-%m')", NULL, FALSE);
   // $this->db->where('students.id', $child_id);
//$this->db->where("MONTH(school_meal_planner.date) = MONTH('$date')", NULL, FALSE);
// $this->db->where("YEAR(school_meal_planner.date) = YEAR('$date')", NULL, FALSE);
    $this->db->order_by('school_meal_planner.id','asc');
    $query= $this->db->get(); 
    return $query->result_array();
}

/*fetch school about us for parent */
public function get_parent_school_aboutus($child_id)
{
    $this->db->select("DISTINCT school_aboutus.*", FALSE);
    $this->db->from("school_aboutus");
    $this->db->join('students', 'students.school_id = school_aboutus.school_id', 'inner');
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('students.id', $child_id);
    $query= $this->db->get(); 
    return $query->result_array();
}
/*fetch school terms and conditions for parent */
public function get_parent_school_terms_condition($child_id)
{
    $this->db->select("DISTINCT school_terms_and_conditions.*", FALSE);
    $this->db->from("school_terms_and_conditions");
    $this->db->join('students', 'students.school_id = school_terms_and_conditions.school_id', 'inner');
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('students.id', $child_id);
    $query= $this->db->get(); 
    return $query->result_array();
}
/*fetch school privacy policy for parent */
public function get_parent_school_privacy_policy($child_id)
{
    $this->db->select("DISTINCT school_privacy_policy.*", FALSE);
    $this->db->from("school_privacy_policy");
    $this->db->join('students', 'students.school_id = school_privacy_policy.school_id', 'inner');
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('students.id', $child_id);
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_child_school_details($child_id)
{
    $this->db->select("DISTINCT schools_info.*", FALSE);
    $this->db->from("schools_info");
    $this->db->join('students', 'students.school_id = schools_info.school_id', 'inner');
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('students.id', $child_id);
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_student_dairy_details($child_id,$date)
{
    $this->db->select("students_dairy_details.*");
    $this->db->from("students_dairy_details");
    $this->db->join("students", "students.id = students_dairy_details.student_id", "left");
    //$this->db->where("school_aboutus.meal_type",$meal_type);
 //   $this->db->where("students_dairy_details.class_id", "students.class_id");
    $this->db->where("students_dairy_details.class_id = students.class_id", NULL, FALSE);
    $this->db->where("students_dairy_details.date", $date);
    $this->db->group_start();
    $this->db->where("students_dairy_details.student_id", $child_id);
    $this->db->or_where("students_dairy_details.student_id", 0);
    $this->db->group_end();
    $query= $this->db->get(); 
    return $query->result_array();
}
public function dairy_delivery_report_of_all_student($dairy_id,$class_id)
{
   $this->db->select('s.student_name,dr.*,IFNULL(dr.created_on, "") AS created_on'); 
   $this->db->from('students s');
   $this->db->join("students_dairy_delivery_report dr", "s.id = dr.student_id AND dr.dairy_id = $dairy_id", "left");
   $this->db->where("s.class_id", $class_id);
   $query= $this->db->get(); 
    return $query->result_array();
   
}

public function dairy_delivery_report_of_student($dairy_id,$student_id)
{
   $this->db->select('s.student_name,dr.*,IFNULL(dr.created_on, "") AS created_on'); 
   $this->db->from('students s');
   $this->db->join("students_dairy_delivery_report dr", "s.id = dr.student_id AND dr.dairy_id = $dairy_id", "left");
   $this->db->where("s.id", $student_id);
   $query= $this->db->get(); 
    return $query->result_array();
   
}

public function get_parent_child_calender_deatils($child_id,$date,$calender_id)
{
     $this->db->select("school_calender_details.*,DATE_FORMAT(school_calender_details.date,'%d') as date,
     DATE_FORMAT(school_calender_details.date,'%d-%m-%Y') as event_date,
    DATE_FORMAT(school_calender_details.date,'%a') as day,TIME_FORMAT(school_calender_details.time,'%h %i %p') as calender_time,
    IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, school_calender_details.class_ids)), '') AS class_names,
    
    IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
     FROM students 
     WHERE FIND_IN_SET(students.id, school_calender_details.student_ids)), '') AS student_names,
     IFNULL((SELECT GROUP_CONCAT(staff.employee_name SEPARATOR ', ') 
     FROM staff 
     WHERE FIND_IN_SET(staff.id, school_calender_details.staff_ids)), '') AS staff_names
    ");
    $this->db->from("school_calender_details");
    // $this->db->join('students', 'students.school_id = school_meal_planner.school_id', 'inner');
    //$this->db->where("school_calender_details.teacher_id",$child_id);
   // $this->db->where("FIND_IN_SET(school_calender_details.student_ids, $child_id) >", 0, FALSE);
   if(!empty($calender_id)){
$this->db->where("school_calender_details.id", $calender_id);
   }else{
      $this->db->where("FIND_IN_SET($child_id, school_calender_details.student_ids) >", 0, FALSE); 
    if(!empty($date)){
        //$this->db->where("school_calender_details.date", $date);
        
$this->db->where("MONTH(school_calender_details.date) = MONTH('$date')", NULL, FALSE);
$this->db->where("YEAR(school_calender_details.date) = YEAR('$date')", NULL, FALSE);
    } 
   }
   
    
    $this->db->order_by("school_calender_details.id","asc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_parent_child_consent_deatils($child_id,$date,$consent_id)
{
     // IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
    //  FROM class 
    //  WHERE FIND_IN_SET(class.id, school_consent_details.class_ids)), '') AS class_names,
    
    // IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
    //  FROM students 
    //  WHERE FIND_IN_SET(students.id, school_consent_details.student_ids)), '') AS student_names,
    
     $this->db->select("school_consent_details.*,
     DATE_FORMAT(school_consent_details.date,'%d-%m-%Y') as date,
    DATE_FORMAT(school_consent_details.date,'%a') as day,
TIME_FORMAT(school_consent_details.time,'%h %i %p') as calender_time,
    staff.employee_name as teacher_name
     
    ");
    $this->db->from("school_consent_details");
     $this->db->join('staff', 'staff.id = school_consent_details.teacher_id', 'left');
    //$this->db->where("school_calender_details.teacher_id",$child_id);
   // $this->db->where("FIND_IN_SET(school_calender_details.student_ids, $child_id) >", 0, FALSE);
   if(!empty($consent_id)){
$this->db->where("school_consent_details.id", $consent_id);
   }else{
   $this->db->where("FIND_IN_SET($child_id, school_consent_details.student_ids) >", 0, FALSE); 
    if(!empty($date)){
        $this->db->where("school_consent_details.created_date <=", date('Y-m-d'));
    }
   }
    
    $this->db->order_by("school_consent_details.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_parent_child_consent_deatils_for_homepage($child_id)
{
     // IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
    //  FROM class 
    //  WHERE FIND_IN_SET(class.id, school_consent_details.class_ids)), '') AS class_names,
    
    // IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
    //  FROM students 
    //  WHERE FIND_IN_SET(students.id, school_consent_details.student_ids)), '') AS student_names,
    
     $this->db->select("school_consent_details.*,DATE_FORMAT(school_consent_details.date,'%d') as date,
    DATE_FORMAT(school_consent_details.date,'%a') as day,TIME_FORMAT(school_consent_details.time,'%h %i %p') as calender_time,
    staff.employee_name as teacher_name
     
    ");
    $this->db->from("school_consent_details");
     $this->db->join('staff', 'staff.id = school_consent_details.teacher_id', 'left');
    //$this->db->where("school_calender_details.teacher_id",$child_id);
   // $this->db->where("FIND_IN_SET(school_calender_details.student_ids, $child_id) >", 0, FALSE);
  
   $this->db->where("FIND_IN_SET($child_id, school_consent_details.student_ids) >", 0, FALSE); 
    
        $this->db->where("school_consent_details.date <=", date('Y-m-d'));
    
   
    
    $this->db->order_by("school_consent_details.id","desc");
    $this->db->limit('2');
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_parent_inbox_replys($message_id)
{
    $this->db->select("rp.*,TIME_FORMAT(rp.created_on,'%h %i %p') as reply_time,
    DATE_FORMAT(rp.created_on,'%d-%m-%Y') as reply_date,
     COALESCE(ss.employee_name, st.student_name, sl.user_type) AS sender_name, 
    ");
    $this->db->from("replys_for_school_admin_messages rp");
    $this->db->join("staff ss", "rp.sender_type = 'teacher' AND ss.id = rp.sender_id", "left");
    $this->db->join("students st", "rp.sender_type = 'parent' AND st.id = rp.sender_id", "left");
    $this->db->join("school_logins sl", "rp.sender_type = 'school_admin' AND  sl.id = rp.sender_id", "left");
    $this->db->where("rp.message_id", $message_id);
    $this->db->order_by("rp.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_parent_sent_replys($message_id)
{
    $this->db->select("rp.*, TIME_FORMAT(rp.created_on,'%h %i %p') as reply_time,
    DATE_FORMAT(rp.created_on,'%d-%m-%Y') as reply_date,
     COALESCE(ss.employee_name, st.student_name, sl.user_type) AS sender_name, 
    ");
    $this->db->from("replys_for_school_parent_messages rp");
    $this->db->join("staff ss", "rp.sender_type = 'teacher' AND ss.id = rp.sender_id", "left");
    $this->db->join("students st", "rp.sender_type = 'parent' AND st.id = rp.sender_id", "left");
    $this->db->join("school_logins sl", "rp.sender_type = 'school_admin' AND  sl.id = rp.sender_id", "left");
    $this->db->where("rp.message_id", $message_id);
    $this->db->order_by("rp.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}


public function get_student_daycare_reports($child_id,$date)
{
     $this->db->select("student_daycare_reports.*,TIME_FORMAT(student_daycare_reports.start_time,'%h %i %p') as start_time,
    ");
    $this->db->from("student_daycare_reports");
   // $this->db->join('staff', 'staff.id = school_consent_details.teacher_id', 'left');
  //  $this->db->where("FIND_IN_SET($child_id, school_consent_details.student_ids) >", 0, FALSE); 
    $this->db->where("student_daycare_reports.student_id", $child_id);
    $this->db->where("student_daycare_reports.date", $date);
    $this->db->order_by("student_daycare_reports.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_school_promotional_details($school_id)
{
    $this->db->select("school_promotions.*,school_promotional_attachments.url");
    $this->db->from("school_promotions");
   $this->db->join('school_promotional_attachments', 'school_promotional_attachments.promotion_id = school_promotions.id', 'left');
  //  $this->db->where("FIND_IN_SET($child_id, school_consent_details.student_ids) >", 0, FALSE); 
    $this->db->where("school_promotions.school_id", $school_id);
    $this->db->order_by("school_promotions.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

/*------------------------------parent fetching end---------------------------*/

/*------------------------------staff fetching start--------------------------*/

/*fetch staff details for login*/
public function get_staff_details($mobile)
{
    $this->db->select("DISTINCT staff.*,staff_rights.*", FALSE);
    $this->db->from("staff");
    $this->db->join('staff_rights', 'staff_rights.staff_id = staff.id', 'left');
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('staff.employee_mobile', $mobile);
    $this->db->where('staff.delete_status', 1);
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_teacher_class_details($teacher_id)
{
    $this->db->select('class.*');
    $this->db->from('class');
    $this->db->where("FIND_IN_SET(id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
    $this->db->where('class.status', 1);
    $this->db->where('class.delete_status', 1);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_teacher_class_stuednts_details($teacher_id,$student_type,$class_id)
{
    $this->db->select('students.*');
$this->db->from('students');
if($class_id == ""){
    $this->db->where("FIND_IN_SET(students.class_id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
}else{
    $ids = explode(",",$class_id);
    $i = 0;
    foreach($ids as $id){
        if($i == 0){
            $this->db->where('students.class_id', $id);
        }else{
            $this->db->or_where('students.class_id', $id);
        }
        $i++;
    }
    //$this->db->where('students.class_id', $class_id);
}
if($student_type == "active"){
    $this->db->where('students.status', 1);
}else if($student_type == "inactive"){
    $this->db->where('students.status', 0);
}
$this->db->where('students.delete_status', 1);
$this->db->order_by('students.id','desc');
$query = $this->db->get();
return $query->result_array();
}

public function get_teacher_class_all_stuednts_details($teacher_id,$student_type,$class_id)
{
    $this->db->select('students.* , IFNULL(mother_dob, "") AS mother_dob, IFNULL(father_dob, "") AS father_dob,
    IFNULL(anniversary_date, "") AS anniversary_date');
$this->db->from('students');
if($class_id == ""){
   // $this->db->where("FIND_IN_SET(students.class_id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
}else{
    // $ids = explode(",",$class_id);
    // $i = 0;
    // foreach($ids as $id){
    //     if($i == 0){
    //         $this->db->where('students.class_id', $id);
    //     }else{
    //         $this->db->or_where('students.class_id', $id);
    //     }
    //     $i++;
    // }
    // //$this->db->where('students.class_id', $class_id);
}
if($student_type == "active"){
    $this->db->where('students.status', 1);
}else if($student_type == "inactive"){
    $this->db->where('students.status', 0);
}
$this->db->where('students.delete_status', 1);
$this->db->order_by('students.id','desc');
$query = $this->db->get();
return $query->result_array();
}

public function get_teacher_class_search_stuednts_details($teacher_id,$student_type,$class_id,$search_key)
{
    $this->db->select('students.* , IFNULL(mother_dob, "") AS mother_dob, IFNULL(father_dob, "") AS father_dob,
    IFNULL(anniversary_date, "") AS anniversary_date');
$this->db->from('students');
if($class_id == ""){
    $this->db->where("FIND_IN_SET(students.class_id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
}else{
    $ids = explode(",",$class_id);
    $i = 0;
    foreach($ids as $id){
        if($i == 0){
            $this->db->where('students.class_id', $id);
        }else{
            $this->db->or_where('students.class_id', $id);
        }
        $i++;
    }
    //$this->db->where('students.class_id', $class_id);
}
if($student_type == "active"){
    $this->db->where('students.status', 1);
}else if($student_type == "inactive"){
    $this->db->where('students.status', 0);
}
if(!empty($search_key)){
  $this->db->like('students.student_name', $search_key);  
}
$this->db->where('students.delete_status', 1);
$this->db->order_by('students.id','desc');
$query = $this->db->get();
return $query->result_array();
}

public function get_teacher_class_search_all_stuednts_details($teacher_id,$student_type,$class_id,$search_key) 
{
    $this->db->select('students.*, IFNULL(mother_dob, "") AS mother_dob, IFNULL(father_dob, "") AS father_dob,
    IFNULL(anniversary_date, "") AS anniversary_date');
$this->db->from('students');
if($class_id == ""){
   // $this->db->where("FIND_IN_SET(students.class_id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
}else{
    // $ids = explode(",",$class_id);
    // $i = 0;
    // foreach($ids as $id){
    //     if($i == 0){
    //         $this->db->where('students.class_id', $id);
    //     }else{
    //         $this->db->or_where('students.class_id', $id);
    //     }
    //     $i++;
    // }
    //$this->db->where('students.class_id', $class_id);
}
if($student_type == "active"){
    $this->db->where('students.status', 1);
}else if($student_type == "inactive"){
    $this->db->where('students.status', 0);
}
if(!empty($search_key)){
  $this->db->like('students.student_name', $search_key);  
}

$this->db->where('students.delete_status', 1);
$this->db->order_by('students.id','desc');
$query = $this->db->get();
return $query->result_array();
}

public function get_teacher_class_stuednts_dairy_remarks_details($teacher_id,$class_id,$date,$type)
{
    $this->db->select("students.*, IFNULL(sd.remarks, '') AS remarks  ");
$this->db->from('students');
$this->db->join("students_dairy_details sd","sd.student_id = students.id AND sd.date = '".$date."' AND sd.type = '".$type."' AND 
 sd.teacher_id = '".$teacher_id."'","left");
if($class_id == ""){
    $this->db->where("FIND_IN_SET(students.class_id, (SELECT employee_class FROM staff WHERE id = $teacher_id)) >", 0);
}else{
    $this->db->where('students.class_id', $class_id);
}
//if($student_type == "active"){
    $this->db->where('students.status', 1);
//}else if($student_type == "inactive"){
//    $this->db->where('students.status', 0);
//}
$this->db->where('students.delete_status', 1);
$this->db->order_by('students.id','desc');
$query = $this->db->get();
return $query->result_array();
}

public function get_teacher_calender_deatils($teacher_id,$date,$calender_id)
{
     $this->db->select("school_calender_details.*,DATE_FORMAT(school_calender_details.date,'%d') as date,
    DATE_FORMAT(school_calender_details.date,'%a') as day,DATE_FORMAT(school_calender_details.date,'%d-%m-%Y') as calender_date,
    
    IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, school_calender_details.class_ids)), '') AS class_names,
    
    IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
     FROM students 
     WHERE FIND_IN_SET(students.id, school_calender_details.student_ids)), '') AS student_names,
     IFNULL((SELECT GROUP_CONCAT(staff.employee_name SEPARATOR ', ') 
     FROM staff 
     WHERE FIND_IN_SET(staff.id, school_calender_details.staff_ids)), '') AS staff_names,
     IFNULL((SELECT GROUP_CONCAT(school_groups.group_name SEPARATOR ', ') 
     FROM school_groups 
     WHERE FIND_IN_SET(school_groups.id, school_calender_details.group_ids)), '') AS group_names
    ");
    $this->db->from("school_calender_details");
    $this->db->where("school_calender_details.teacher_id",$teacher_id);
    if(!empty($date)){
       // $this->db->where("school_calender_details.date", $date);
        $this->db->where("MONTH(school_calender_details.date) = MONTH('$date')", NULL, FALSE);
$this->db->where("YEAR(school_calender_details.date) = YEAR('$date')", NULL, FALSE);
    }
    if(!empty($calender_id)){
        $this->db->where("school_calender_details.id", $calender_id);
    }
    
    $this->db->order_by("school_calender_details.id","asc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_teacher_consent_deatils($teacher_id,$date,$consent_id)
{
     $this->db->select("school_consent_details.*,DATE_FORMAT(school_consent_details.date,'%d') as date,
    DATE_FORMAT(school_consent_details.date,'%a') as day,TIME_FORMAT(school_consent_details.time,'%h %i %p') as calender_time,
    
    IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, school_consent_details.class_ids)), '') AS class_names,
    
    IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
     FROM students 
     WHERE FIND_IN_SET(students.id, school_consent_details.student_ids)), '') AS student_names,
     
     IFNULL((SELECT GROUP_CONCAT(school_groups.group_name SEPARATOR ', ') 
     FROM school_groups 
     WHERE FIND_IN_SET(school_groups.id, school_consent_details.group_ids)), '') AS group_names,
    
    ");
    $this->db->from("school_consent_details");
    $this->db->where("school_consent_details.teacher_id",$teacher_id);
    if(!empty($date)){
        $this->db->where("school_consent_details.date", $date);
    }
    if(!empty($consent_id)){
        $this->db->where("school_consent_details.id", $consent_id);
    }
    
    $this->db->order_by("school_consent_details.id","asc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_teacher_albums_details($teacher_id,$school_id,$album_id)
{
    $this->db->select("albums.id,albums.title,albums.album_type,albums.school_id,albums.type,
    albums.description,albums.classes,albums.groups,
    IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, albums.classes)), '') AS class_names,
     IFNULL((SELECT GROUP_CONCAT(school_groups.group_name SEPARATOR ', ') 
     FROM school_groups 
     WHERE FIND_IN_SET(school_groups.id, albums.groups)), '') AS group_names
    ");
    $this->db->from("albums");
 //   $this->db->join("album_content","album_content.album_id = albums.id","left");
   // $this->db->join('(SELECT * FROM album_content WHERE id IN (SELECT MIN(id) FROM album_content GROUP BY album_id)) sd', 'albums.id = album_content.album_id', 'left');
    if(!empty($album_id)){
        $this->db->where('albums.id',$album_id);
    }else{
        $this->db->where('albums.teacher_id',$teacher_id);
    $this->db->where('albums.school_id',$school_id);
    }
    
   //  $this->db->group_by('albums.id');
     $this->db->order_by('albums.id', 'desc'); // or DESC to get the latest record
    $query = $this->db->get();
    return $query->result_array();
}

public function fetch_album_content_for_teacher($album_id)
{
    $this->db->select("album_content.*", FALSE);
    $this->db->from("album_content");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('album_content.album_id', $album_id);
    $this->db->limit("1");
    $query= $this->db->get(); 
    return $query->result_array();
}

/*fetch staff inbox messages*/
public function get_staff_inbox_search_messages_of_parent($teacher_id,$school_id,$search_subject)
{
    $no = "no name";
    $this->db->select("parent_messages.*,DATE_FORMAT(parent_messages.date,'%d-%m-%Y') as date,
    students.student_name as name,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("parent_messages");
    $this->db->join("students","students.id = parent_messages.student_id","inner");
    $this->db->join("staff","FIND_IN_SET(students.class_id, staff.employee_class) > 0","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = parent_messages.id AND staff_read_messages.message_type = 'teacher' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    // if(!empty($inbox_message_id)){
    //     $this->db->where("staff_messages.id",$inbox_message_id);
    // }
    if(!empty($search_subject)){
        //$this->db->where("messages.id",$inbox_message_id);
       $this->db->like('parent_messages.subject', $search_subject);
    }
    
   $this->db->where("FIND_IN_SET('students.class_id', staff.employee_class) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("parent_messages.date <=",date('Y-m-d'));
   $this->db->order_by("parent_messages.id","desc");
    $query= $this->db->get(); 
    //echo $this->db->last_query();exit;
    return $query->result_array();
}

public function get_staff_inbox_search_messages_of_staff($teacher_id,$school_id,$search_subject)
{
    $no = "no name";
    $this->db->select("staff_messages.*,DATE_FORMAT(staff_messages.date,'%d-%m-%Y') as date,
    staff.employee_name as name,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("staff_messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = staff_messages.id AND staff_read_messages.message_type = 'staff' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
   if(!empty($search_subject)){
        //$this->db->where("messages.id",$inbox_message_id);
       $this->db->like('staff_messages.subject', $search_subject);
    }
   $this->db->where("FIND_IN_SET($teacher_id, staff_messages.to_staff) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("staff_messages.date <=",date('Y-m-d'));
   $this->db->order_by("staff_messages.id","desc");
    $query= $this->db->get();
  //  echo $this->db->last_query();exit;
    return $query->result_array();
}

public function get_staff_inbox_search_messages_of_admin($teacher_id,$school_id,$search_subject)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = messages.id AND staff_read_messages.message_type = 'staff' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   if(!empty($search_subject)){
        //$this->db->where("messages.id",$inbox_message_id);
       $this->db->like('messages.subject', $search_subject);
    }
    if(!empty($inbox_message_id)){
        $this->db->where("messages.id",$inbox_message_id);
    }
   $this->db->where("FIND_IN_SET($teacher_id, messages.to_staff) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("messages.date <=",date('Y-m-d'));
   $this->db->order_by("messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}



public function get_staff_inbox_messages_of_parent($teacher_id,$school_id)
{
    $no = "no name";
    $this->db->select("parent_messages.*,DATE_FORMAT(parent_messages.date,'%d-%m-%Y') as date,
    students.student_name as name,students.student_image as image,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("parent_messages");
    $this->db->join("students","students.id = parent_messages.student_id","inner");
    $this->db->join("staff","FIND_IN_SET(students.class_id, staff.employee_class) > 0","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = $teacher_id AND 
    staff_read_messages.message_id = parent_messages.id AND staff_read_messages.message_type = 'parent' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    // if(!empty($inbox_message_id)){
    //     $this->db->where("staff_messages.id",$inbox_message_id);
    // }
   $this->db->where("FIND_IN_SET('students.class_id', staff.employee_class) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("parent_messages.date <=",date('Y-m-d'));
   $this->db->order_by("parent_messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}


public function get_staff_inbox_messages_of_staff($teacher_id,$school_id)
{
    $no = "no name";
    $this->db->select("staff_messages.*,DATE_FORMAT(staff_messages.date,'%d-%m-%Y') as date,
    staff.employee_name as name,staff.employee_image as image,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("staff_messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = staff_messages.id AND staff_read_messages.message_type = 'teacher' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    // if(!empty($inbox_message_id)){
    //     $this->db->where("staff_messages.id",$inbox_message_id);
    // }
   $this->db->where("FIND_IN_SET($teacher_id, staff_messages.to_staff) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("staff_messages.date <=",date('Y-m-d'));
   $this->db->order_by("staff_messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_staff_inbox_messages_of_admin($teacher_id,$school_id)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = messages.id AND staff_read_messages.message_type = 'school_admin' ","left",FALSE);
   // $this->db->where('students.delete_status',1);
  //  $this->db->where("parent_messages.student_id",$child_id);
   // $this->db->where_in($child_id, 'messages.to_student');
   
    if(!empty($inbox_message_id)){
        $this->db->where("messages.id",$inbox_message_id);
    }
   $this->db->where("FIND_IN_SET($teacher_id, messages.to_staff) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
   $this->db->where("messages.date <=",date('Y-m-d'));
   $this->db->order_by("messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}







public function get_staff_inbox_message_details_of_admin($teacher_id,$inbox_message_id)
{
    $no = "no name";
    $this->db->select("messages.*,DATE_FORMAT(messages.date,'%d-%m-%Y') as date,
    messages.attachments,staff.employee_image as profile_image,schools_info.school_name as name,
    
    COALESCE(DATE_FORMAT(messages.schedule_date,'%d-%m-%Y'), '')  AS schedule_date, 
    COALESCE(TIME_FORMAT(messages.schedule_time,'%h %i %p'), '') AS schedule_time, 

    
    COALESCE(staff_read_messages.read_message, '') AS read_message, 
    COALESCE(staff_read_messages.starred_message, '') AS starred_message, 
    COALESCE(staff_read_messages.archived_message, '') AS archived_message,
    
     IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, messages.to_class)), '') AS class_names,
    
    IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
     FROM students 
     WHERE FIND_IN_SET(students.id, messages.to_student)), '') AS student_names,  
     
    IFNULL((SELECT GROUP_CONCAT(staff.employee_name SEPARATOR ', ') 
     FROM staff 
     WHERE FIND_IN_SET(staff.id, messages.to_staff)), '') AS staff_names,
   
    IFNULL((SELECT GROUP_CONCAT(school_groups.group_name SEPARATOR ', ') 
     FROM school_groups 
     WHERE FIND_IN_SET(school_groups.id, messages.to_group)), '') AS group_names
    
    ");
    $this->db->from("messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("schools_info","schools_info.school_id = messages.school_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = messages.id AND staff_read_messages.message_type = 'school_admin' ","left",FALSE);
    if(!empty($inbox_message_id)){
        $this->db->where("messages.id",$inbox_message_id);
    }
   // echo $this->db->last_query();exit;
    $query= $this->db->get(); 
    return $query->result_array();
}
public function get_staff_inbox_message_details_of_staff($teacher_id,$inbox_message_id)
{
    $no = "no name";
    $this->db->select("staff_messages.*,DATE_FORMAT(staff_messages.date,'%d-%m-%Y') as date,
    staff.employee_name as name,staff_messages.attachments,staff.employee_image as profile_image,
    COALESCE(DATE_FORMAT(staff_messages.schedule_date,'%d-%m-%Y'), '')  AS schedule_date, 
    COALESCE(TIME_FORMAT(staff_messages.schedule_time,'%h %i %p'), '') AS schedule_time, 

    
    COALESCE(staff_read_messages.read_message, '') AS read_message, 
    COALESCE(staff_read_messages.starred_message, '') AS starred_message, 
    COALESCE(staff_read_messages.archived_message, '') AS archived_message,
    
     IFNULL((SELECT GROUP_CONCAT(class.class_name SEPARATOR ', ') 
     FROM class 
     WHERE FIND_IN_SET(class.id, staff_messages.to_class)), '') AS class_names,
    
    IFNULL((SELECT GROUP_CONCAT(students.student_name SEPARATOR ', ') 
     FROM students 
     WHERE FIND_IN_SET(students.id, staff_messages.to_student)), '') AS student_names,  
     
    IFNULL((SELECT GROUP_CONCAT(staff.employee_name SEPARATOR ', ') 
     FROM staff 
     WHERE FIND_IN_SET(staff.id, staff_messages.to_staff)), '') AS staff_names,
   
    IFNULL((SELECT GROUP_CONCAT(school_groups.group_name SEPARATOR ', ') 
     FROM school_groups 
     WHERE FIND_IN_SET(school_groups.id, staff_messages.to_group)), '') AS group_names
     
    
    ");
    $this->db->from("staff_messages");
    $this->db->join("staff","staff.id = $teacher_id","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = staff.id AND 
    staff_read_messages.message_id = staff_messages.id AND staff_read_messages.message_type = 'teacher' ","left",FALSE);
    if(!empty($inbox_message_id)){
        $this->db->where("staff_messages.id",$inbox_message_id);
    }
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_staff_inbox_message_details_of_parent($teacher_id,$inbox_message_id)
{
    $no = "no name";
    $this->db->select("parent_messages.*,DATE_FORMAT(parent_messages.date,'%d-%m-%Y') as date,
    students.student_name as name,parent_messages,parent_messages.attachment as attachments,
    students.father_name as father_name,students.student_image as profile_image,
    IFNULL(staff_read_messages.read_message, '') AS read_message, 
    IFNULL(staff_read_messages.starred_message, '') AS starred_message, 
    IFNULL(staff_read_messages.archived_message, '') AS archived_message
    
    ");
    $this->db->from("parent_messages");
    $this->db->join("students","students.id = parent_messages.student_id","inner");
    //$this->db->join("staff","FIND_IN_SET(students.class_id, staff.employee_class) > 0","left");
    $this->db->join("staff_read_messages","staff_read_messages.staff_id = $teacher_id AND 
    staff_read_messages.message_id = parent_messages.id AND staff_read_messages.message_type = 'parent' ","left",FALSE);
   
    if(!empty($inbox_message_id)){
        $this->db->where("parent_messages.id",$inbox_message_id);
    }
   //$this->db->where("FIND_IN_SET('students.class_id', staff.employee_class) >", 0, FALSE); 
   // echo $this->db->last_query();exit;
//   $this->db->where("parent_messages.date <=",date('Y-m-d'));
//   $this->db->order_by("parent_messages.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_teacher_admin_groups($teacher_id)
{
    $this->db->select("school_groups.*");
    $this->db->from("school_groups");
    $this->db->where("FIND_IN_SET($teacher_id, school_groups.group_admins) >", 0, FALSE); 
    $this->db->order_by("school_groups.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}
public function get_teacher_admin_group_students($group_id)
{
    $this->db->select("students.*");
    $this->db->from('students');
    $this->db->join('school_groups', 'FIND_IN_SET(students.id, school_groups.group_students)');
    $this->db->where('school_groups.id', $group_id);
    $this->db->order_by("school_groups.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_group_students_with_daycarerecords($group_id,$date)
{
    $this->db->select('s.id, s.student_name,s.student_image, IF(drs.student_id IS NOT NULL, "Yes", "No") AS has_daycare_report');
    $this->db->from('school_groups gs');
    $this->db->join('students s', 'FIND_IN_SET(s.id, gs.group_students)');
    $this->db->join('daycare_reports_studnets drs', 's.id = drs.student_id', 'left'); // LEFT JOIN to include all students
    $this->db->join('daycare_reports dr', 'drs.daycare_report_id = dr.id', 'left');
    $this->db->where('gs.id',$group_id);
    $this->db->where('dr.date',$date);
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_group_students_details($group_id)
{
    $this->db->select('s.id, s.student_name,s.student_image,s.admission_id');
    $this->db->from('school_groups gs');
    $this->db->join('students s', 'FIND_IN_SET(s.id, gs.group_students)');
    $this->db->where('gs.id',$group_id);
    $query= $this->db->get(); 
    return $query->result_array();
}


/*fetch parent sent messages*/
public function get_staff_sent_messages($teacher_id,$school_id,$message_type,$sent_message_id)
{
   // GROUP_CONCAT(DISTINCT s.student_name) AS student_names, 
     //              GROUP_CONCAT(DISTINCT st.employee_name) AS staff_names
    $this->db->select("m.*,DATE_FORMAT(m.date,'%d-%m-%Y') as date,TIME_FORMAT(m.schedule_time,'%h %i %p') as schedule_time,
    COALESCE(GROUP_CONCAT(DISTINCT s.student_name SEPARATOR ', '), '') AS student_names, 
                   COALESCE(GROUP_CONCAT(DISTINCT st.employee_name SEPARATOR ', '), '') AS staff_names
                   
                   ");
    $this->db->from("staff_messages m");
    $this->db->join("students s", "FIND_IN_SET(s.id, m.to_student)", "left");
    $this->db->join("staff st", "FIND_IN_SET(st.id, m.to_staff)", "left");
   // $this->db->where('students.delete_status',1);
    $this->db->where("m.teacher_id",$teacher_id);
    $this->db->where("m.school_id",$school_id);
    
   
    if(!empty($sent_message_id)){
        $this->db->where("m.id",$sent_message_id);
    }else{
       if(empty($message_type)){
         $this->db->where("m.message_type","normal");
    }else{
        $this->db->where("m.message_type","scheduled");
    } 
    }
    $this->db->order_by('m.id','desc');
    $this->db->group_by('m.id','desc');
    $query= $this->db->get(); 
    return $query->result_array();
}
public function get_staff_sent_replys($message_id)
{
    $this->db->select("rp.*, TIME_FORMAT(rp.created_on,'%h %i %p') as reply_time,
    DATE_FORMAT(rp.created_on,'%d-%m-%Y') as reply_date,
     COALESCE(ss.employee_name, st.student_name, sl.user_type) AS sender_name, 
    ");
    $this->db->from("replys_for_school_staff_messages rp");
    $this->db->join("staff ss", "rp.sender_type = 'teacher' AND ss.id = rp.sender_id", "left");
    $this->db->join("students st", "rp.sender_type = 'parent' AND st.id = rp.sender_id", "left");
    $this->db->join("school_logins sl", "rp.sender_type = 'school_admin' AND  sl.id = rp.sender_id", "left");
    $this->db->where("rp.message_id", $message_id);
    $this->db->order_by("rp.id","desc");
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_student_daycare_reports_for_teacher($student_id,$date)
{
    $this->db->select('dr.*, IFNULL(ac.activity_name,"") AS activity_name');
    $this->db->from('daycare_reports dr');
    $this->db->join('daycare_reports_studnets drs', 'dr.id = drs.daycare_report_id');
    $this->db->join('activities ac','ac.id = dr.activity_id','left');
    $this->db->where('drs.student_id', $student_id);
    $this->db->where('dr.date', $date); // Filter for today's report
    $query = $this->db->get();
    //echo $this->db->last_query();exit;
    return $query->result_array(); // Returns a single result
}
public function get_student_attendance_class_wise($school_id,$class_id,$date)
{
    $this->db->select("s.id AS student_id,s.student_name,s.student_image,
    IFNULL(sa.total_present,0) AS total_present_students,
    IFNULL(sa.total_absent,0) AS total_absent_students,
    CASE 
                      WHEN ps.student_id IS NOT NULL THEN 'Yes'
                      WHEN ab.student_id IS NOT NULL THEN 'No'
                      ELSE 'Not Taken'
                  END AS attendance_status");
    $this->db->from("students s");
    $this->db->join("student_attendance_day_wise sa","sa.class_id = s.class_id AND sa.date = '$date'","left");
    $this->db->join('class c', 's.class_id = c.id');
    $this->db->join('present_students ps', 'sa.id = ps.attendance_id AND s.id = ps.student_id', 'left');
    $this->db->join('absent_students ab', 'sa.id = ab.attendance_id AND s.id = ab.student_id', 'left');
    $this->db->where("s.class_id",$class_id);
   // $this->db->where('sa.date', $date);
    
//     $this->db->select('s.id AS student_id, s.student_name, 
//     CASE 
//         WHEN ps.student_id IS NOT NULL THEN "Yes"
//         WHEN ab.student_id IS NOT NULL THEN "No"
//         ELSE "Not Taken"
//     END AS attendance_status');
// $this->db->from('students s');
// $this->db->join('class c', 's.class_id = c.id', 'left');
// $this->db->join('student_attendance_day_wise sa', 'sa.class_id = s.class_id AND sa.date = "'.$date.'"', 'left');
// $this->db->join('present_students ps', 'sa.id = ps.attendance_id AND s.id = ps.student_id', 'left');
// $this->db->join('absent_students ab', 'sa.id = ab.attendance_id AND s.id = ab.student_id', 'left');
// $this->db->where('s.class_id', $class_id);


    $query = $this->db->get();
    return $query->result_array();
}


public function get_all_staff_details($school_id,$staff_type,$staff_id)
{
    $this->db->select('s.*,  GROUP_CONCAT(c.class_name ORDER BY c.class_name SEPARATOR ", ") AS class_names', false); 
    $this->db->from('staff s');
    $this->db->join('class c', 'FIND_IN_SET(c.id, s.employee_class)', 'left');
    $this->db->where('s.school_id',$school_id);
    if($staff_type == "active"){
        $this->db->where('s.status',1);
    }else if($staff_type == "inactive"){
        $this->db->where('s.status',0);
    }
    if(!empty($staff_id)){
        $this->db->where('s.id',$staff_id);
    }
    $this->db->where('s.delete_status',1);
    $this->db->group_by("s.id");
    $this->db->order_by("s.id","desc");
    $query = $this->db->get();
    return $query->result_array();
}
public function get_search_staff_details($school_id,$staff_type,$search_key)
{
    $this->db->select('s.*');
    $this->db->from('staff s');
    $this->db->where('s.school_id',$school_id);
    if($staff_type == "active"){
        $this->db->where('s.status',1);
    }else if($staff_type == "inactive"){
        $this->db->where('s.status',0);
    }
    if(!empty($search_key)){
         $this->db->like('s.employee_name', $search_key);
    }
   
    $this->db->where('s.delete_status',1);
    $this->db->order_by("s.id","desc");
    $query = $this->db->get();
    return $query->result_array();
}
public function get_staff_rights_details($staff_id)
{
    $this->db->select("s.*,
    CASE 
                      WHEN sa.id IS NOT NULL THEN 'Yes'
                      WHEN sa.id IS  NULL THEN 'No'
                  END AS status");
    $this->db->from("school_employee_all_rights_list s");
    $this->db->join("staff_all_rights sa","sa.right_id = s.id AND sa.staff_id = '$staff_id'","left");
    $this->db->join("staff ss","ss.id = sa.staff_id","left");
    //$this->db->where("ss.id",$staff_id);
    $this->db->order_by("s.id","desc");
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_groups($school_id,$group_id)
{
    $this->db->select("sg.*, 
    (SELECT GROUP_CONCAT(s.employee_name) 
     FROM staff s WHERE FIND_IN_SET(s.id, sg.group_staff)) AS school_members, 
    (SELECT GROUP_CONCAT(s.employee_name) 
     FROM staff s WHERE FIND_IN_SET(s.id, sg.group_admins)) AS group_admins_names,
     
     COALESCE(GROUP_CONCAT(DISTINCT ss.student_name SEPARATOR ', '), '') AS student_names,
                   
    (LENGTH(sg.group_students) - LENGTH(REPLACE(sg.group_students, ',', '')) + 1) AS student_count", false
    
    );
    $this->db->from("school_groups sg");
    $this->db->join("students ss", "FIND_IN_SET(ss.id, sg.group_students)", "left");
    $this->db->where("sg.school_id",$school_id);
    if(!empty($group_id)){
        $this->db->where("sg.id",$group_id);
    }
    $this->db->group_by("sg.id");
    $this->db->order_by("sg.id","desc");
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_subject_teachers_list($school_id,$class_id)
{
     $this->db->select('ss.id, ss.subject_name, GROUP_CONCAT(s.employee_name SEPARATOR ", ") as teachers,GROUP_CONCAT(s.id SEPARATOR ", ") as teacher_ids');
        $this->db->from('school_subjects ss');
        $this->db->join('subject_teachers st', 'st.subject_id = ss.id', 'inner'); // INNER JOIN ensures subjects have teachers
        $this->db->join('staff s', 'st.teacher_id = s.id', 'inner');
        $this->db->where('ss.school_id',$school_id);
        if(!empty($class_id)){
             $this->db->where("FIND_IN_SET('$class_id', s.employee_class) > 0");
       
        }
        $this->db->group_by('ss.id');
        return $this->db->get()->result();
}
public function get_all_class_details($school_id,$type,$class_name,$class_teacher,$session_id)
{
    $this->db->select('c.session_id,c.id, c.class_name, c.class_section, COUNT(s.id) AS student_count,
     CONCAT(ss.from_year, " - ", ss.to_year) AS class_session,
    (SELECT COUNT(*) FROM students) AS total_students', false);
    $this->db->from('class c');
    $this->db->join("school_sessions ss", "ss.id = c.session_id", "left"); 
    $this->db->join("students s", "c.id = s.class_id", "left"); 
    if(!empty($class_teacher)){
        $this->db->join("class_teachers ct", "ct.class_id = c.id AND ct.teacher_id = $class_teacher", "left");
    }
    $this->db->where('c.school_id',$school_id);
    if($type == "active"){
        $this->db->where('c.status',1);
    }else if($type == "inactive"){
        $this->db->where('c.status',0);
    }
    if(!empty($class_name)){
        //$this->db->where('c.class_name',1);
        $this->db->like('c.class_name', $class_name);
    }
    if(!empty($session_id)){
        //$this->db->where('c.class_name',1);
        $this->db->like('c.session_id', $session_id);
    }
    
    $this->db->where('c.delete_status',1);
    $this->db->group_by("c.id, c.class_name");
    $query = $this->db->get();
    return $query->result_array();
}
public function get_single_class_details($class_id)
{
    

$this->db->select("c.*, 
    CONCAT(ss.from_year, ' - ', ss.to_year) AS class_session,
    COALESCE(GROUP_CONCAT(st.id ORDER BY st.id SEPARATOR ', '), '') AS teacher_ids,
    COALESCE(GROUP_CONCAT(st.employee_name ORDER BY st.employee_name SEPARATOR ', '), '') AS teacher_names", false);
$this->db->from("class c");
$this->db->join("school_sessions ss", "ss.id = c.session_id", "left");
$this->db->join("class_teachers ct", "ct.class_id = c.id", "left");
$this->db->join("staff st", "st.id = ct.teacher_id", "left");
$this->db->where("c.id", $class_id);
$this->db->group_by("c.id");

$query = $this->db->get();
return $result = $query->result_array();
}
public function get_session_details($school_id)
{
    $this->db->select("ss.session_name, 
    CASE 
        WHEN ss.status = 1 THEN 'ACTIVE' 
        WHEN ss.status = 0 THEN 'INACTIVE' 
        ELSE 'UNKNOWN' 
    END AS session_status, 
    ss.id", false);
    $this->db->from("school_sessions ss");
    $this->db->where("ss.delete_status", 1);
    $this->db->order_by("ss.id","desc");
    $query = $this->db->get();
    return $result = $query->result_array();
}

/*fetch meal planner */
public function get_teacher_meal_palnner($school_id,$date,$meal_type)
{
//     $this->db->select("DISTINCT school_meal_planner.*,DATE_FORMAT(school_meal_planner.date,'%d') as date,
//     DATE_FORMAT(school_meal_planner.date,'%a ') as day,", FALSE);
//     $this->db->from("school_meal_planner");
//     $this->db->join('students', 'students.school_id = school_meal_planner.school_id', 'inner');
//     $this->db->where("school_meal_planner.meal_type",$meal_type);
//     $this->db->where('students.id', $child_id);
// $this->db->where("MONTH(school_meal_planner.date) = MONTH('$date')", NULL, FALSE);
// $this->db->where("YEAR(school_meal_planner.date) = YEAR('$date')", NULL, FALSE);

   // $this->db->where("DATE_FORMAT(school_meal_planner.date, '%Y-%m') = DATE_FORMAT('$date', '%Y-%m')", NULL, FALSE);
   // $this->db->where('students.id', $child_id);
//$this->db->where("MONTH(school_meal_planner.date) = MONTH('$date')", NULL, FALSE);
// $this->db->where("YEAR(school_meal_planner.date) = YEAR('$date')", NULL, FALSE);
    // $this->db->order_by('school_meal_planner.id','asc');
    // $query= $this->db->get(); 
    // return $query->result_array();
    
    $this->db->select("mp.*,DATE_FORMAT(mp.date,'%d') as date,
    DATE_FORMAT(mp.date,'%a ') as day,", FALSE);
    $this->db->from("school_meal_planner mp");
    $this->db->where('mp.school_id', $school_id);
    $this->db->where("MONTH(mp.date) = MONTH('$date')", NULL, FALSE);
    $this->db->where("YEAR(mp.date) = YEAR('$date')", NULL, FALSE);
    $this->db->where("mp.meal_type",$meal_type);
    $this->db->order_by('mp.id','asc');
    $query= $this->db->get(); 
    return $query->result_array();
    
    
}

public function get_all_cabs_list($school_id)
{
    $this->db->select("c.id,c.cab_name,c.vehicle_no,c.driver_name,c.driver_no,");
    $this->db->from("cabs c");
    $this->db->where('c.school_id', $school_id);
    // $this->db->where("MONTH(mp.date) = MONTH('$date')", NULL, FALSE);
    // $this->db->where("YEAR(mp.date) = YEAR('$date')", NULL, FALSE);
    $this->db->where("c.status",1);
     $this->db->where("c.delete_status",1);
    $this->db->order_by('c.id','desc');
    $query= $this->db->get(); 
    return $query->result_array();
}

/*fetch school about us for parent */
public function get_teacher_school_aboutus($school_id)
{
    $this->db->select(" school_aboutus.*", FALSE);
    $this->db->from("school_aboutus");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('school_aboutus.school_id', $school_id);
    $query= $this->db->get(); 
    return $query->result_array();
}
/*fetch school terms and conditions for parent */
public function get_teacher_school_terms_condition($school_id)
{
    $this->db->select(" school_terms_and_conditions.*", FALSE);
    $this->db->from("school_terms_and_conditions");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('school_terms_and_conditions.school_id', $school_id);
    $query= $this->db->get(); 
    return $query->result_array();
}
/*fetch school privacy policy for parent */
public function get_teacher_school_privacy_policy($school_id)
{
    $this->db->select(" school_privacy_policy.*", FALSE);
    $this->db->from("school_privacy_policy");
    
    //$this->db->where("school_aboutus.meal_type",$meal_type);
    $this->db->where('school_privacy_policy.school_id', $school_id);
    $query= $this->db->get(); 
    return $query->result_array();
}

public function get_staff_marked_attendance_details($school_id,$teacher_id,$date)
{
    $this->db->select("
        s.employee_name, 
        s.employee_designation, 
        TIME_FORMAT(sa.in_time, '%h:%i %p') as in_time,
        TIME_FORMAT(sa.out_time, '%h:%i %p') as out_time, 
        ( 6371000 * acos(
            cos(radians(si.latitude)) *
            cos(radians(sa.in_time_latitude)) *
            cos(radians(sa.in_time_longitude) - radians(si.longitude)) +
            sin(radians(si.latitude)) *
            sin(radians(sa.in_time_latitude))
        )) AS intime_distance, 
        ( 6371000 * acos(
            cos(radians(si.latitude)) *
            cos(radians(sa.out_time_latitude)) *
            cos(radians(sa.out_time_longitude) - radians(si.longitude)) +
            sin(radians(si.latitude)) *
            sin(radians(sa.out_time_latitude))
        )) AS outtime_distance
    ");
    $this->db->from('staff s');
    $this->db->join('staff_attendance sa', 's.id = sa.staff_id AND sa.date = ' . $this->db->escape($date), 'inner');
    $this->db->join('schools_info si', 's.school_id = si.id', 'inner');  
    $this->db->where('s.school_id', $school_id);

    $query = $this->db->get();
    return $query->result_array();
}

public function get_staff_notmarked_attendance_details($school_id,$teacher_id,$date)
{
    $this->db->select("
        s.employee_name, 
        s.employee_designation
    ");
    $this->db->from('staff s');
    $this->db->join('staff_attendance sa', 's.id = sa.staff_id AND sa.date = ' . $this->db->escape($date), 'left');
 //   $this->db->join('schools_info si', 's.school_id = si.id', 'inner');  
    $this->db->where('s.school_id', $school_id);
    $this->db->where('sa.id IS NULL');
    $query = $this->db->get();
    return $query->result_array();
}

public function get_student_all_details($student_id)
{
    $this->db->select("
        s.*, c.class_name,ss.session_name, DATE_FORMAT(s.joining_date,'%d-%m-%Y') as joining_date, 
         DATE_FORMAT(s.student_dob,'%d-%m-%Y') as student_dob,  DATE_FORMAT(s.father_dob,'%d-%m-%Y') as father_dob,  
         DATE_FORMAT(s.mother_dob,'%d-%m-%Y') as mother_dob,  
        COALESCE(GROUP_CONCAT(sg.group_name ORDER BY s.groups SEPARATOR ', '), '') AS group_names,
        COALESCE(GROUP_CONCAT(ca.cab_name ORDER BY s.cabs SEPARATOR ', '), '') AS cab_names
    ");
    $this->db->from('students s');
    $this->db->join("class c", "c.id = s.class_id", "left");
    $this->db->join("school_sessions ss", "ss.id = s.session_id", "left");
    $this->db->join("school_groups sg", "FIND_IN_SET(sg.id, s.groups)", "left");
    $this->db->join("cabs ca", "FIND_IN_SET(ca.id, s.cabs)", "left");  
    $this->db->where('s.id', $student_id);
   // $this->group_by('s.id');
    $query = $this->db->get();
    return $query->result_array();
}

/*------------------------------staff fetching end--------------------------*/


















public function pending_payments_of_employee($site_id)
{
    $this->db->select('pending_payments.*,MONTHNAME(pending_payments.invoice_date) as invoice_month');
    $this->db->from('pending_payments');
    $this->db->where('pending_payments.site_id',$site_id);
    $query = $this->db->get();
    return $query->result_array();
}
/*fetch incident report*/
public function get_incident_report()
{
    $this->db->select('incident_reports.name_of_the_unit,incident_reports.address,incident_reports.nature_of_incident,employees.name,employees.name,employees.phone_number,employees.login_id');
    $this->db->from('incident_reports');
    $this->db->join('employees','employees.id = incident_reports.employee_id','left');
    $this->db->where('incident_reports.incident_date',date('Y-m-d'));
    $this->db->where('incident_reports.created_on >=', date('Y-m-d H:i:s', strtotime('-5 minutes')));
   // $this->db->where('incident_reports.incident_time <=',date('H:i:s'));
    $query = $this->db->get();
    return $query->result_array();
}
/*fetch incident report*/
/*pending paymnets*/
public function get_pending_payments($days)
{
    $sql = "SELECT
    MONTHNAME(invoice_date) AS month,
    SUM(amount) AS total_payment
FROM
    pending_payments
WHERE
    invoice_date >= DATE_SUB(CURDATE(), INTERVAL $days DAY)
     AND delete_status = 1
   
GROUP BY
    month";
    $query= $this->db->query($sql);
  //  echo $this->db->last_query();exit;
    return $query->result_array();
    
}
/*pending paymnets*/
function get_employee_site_distance($site_id,$latitude,$longitude)
{
    $this->db->select("COALESCE(( 6371 * acos( cos( radians({$latitude}) ) * cos( radians( `latitude` ) ) * cos( radians( longitude ) - radians({$longitude}) ) + sin( radians({$latitude}) ) * sin( radians( `latitude` ) ) ) ), 0) AS distance", False);
    $this->db->from('sites');
    $this->db->where('id', $site_id);
    $dark_stores = $this->db->get();
		return $dark_stores->result();
}


}