<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
class Api extends REST_Controller {

	protected $client_request = NULL;

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		error_reporting(0);
		set_time_limit(0);
		$this->load->model('api/api_model','user_model');
		//$this->load->library('Notifications');
		$this->load->library('form_validation');
		$this->load->library('auth_token');
		
		$this->client_request = new stdClass();
		$this->client_request = json_decode(file_get_contents('php://input', true));
		$this->client_request = json_decode(json_encode($this->client_request), true);
	}
	
	/*access token*/
public function getAccessToken(){
    $serviceAccountFile = FCPATH . 'application/libraries/firebase.json'; // Update this path
    $jsonKey = json_decode(file_get_contents($serviceAccountFile), true);

    $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
    $now = time();
    $exp = $now + 3600;

    $payload = json_encode([
        'iss' => $jsonKey['client_email'],
        'sub' => $jsonKey['client_email'],
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $exp,
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
    ]);

    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    $signature = '';

    $data = $base64UrlHeader . '.' . $base64UrlPayload;
    openssl_sign($data, $signature, $jsonKey['private_key'], 'sha256');

    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    $jwt = $data . '.' . $base64UrlSignature;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }
    curl_close($ch);

    $responseData = json_decode($response, true);
    //print_r($responseData);exit;
    if (isset($responseData['access_token'])) {
        return $responseData['access_token'];
    } else {
        echo 'Error fetching access token: ' . $response;
        return null;
    }
}
/*access token*/

	/*REFERANCE CODE*/
	function referance_post(){
		$response = array('status' => false, 'message' => '', 'response' => array());
		$user_input = $this->client_request;
		extract($user_input);
		if(!$id)
		{
			$response = array('status' => false, 'message' => 'Enter Email ID!', 'response' => array());
			$this->response($response);
		}
		
		
		$this->response($response);
	}
    /*REFERANCE CODE*/
    
    /*token authentication*/
    public function token_get($check_user,$mobile,$token)
    {
        $key = "schoolappkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $mobile,
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
      $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
      if(empty($check)){
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'parent_mobile' => $mobile,
           'school_id' => $check_user[0]['school_id'],
           'created_on' => date('Y-m-d H:i:s')
        );
        $insert = $this->user_model->common_insert('parent_logins',$data);
        $check = $this->user_model->common_fetch('parent_logins',array('id' => $insert));
      }else{
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'parent_mobile' => $mobile,
           'school_id' => $check_user[0]['school_id'],
           'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('parent_logins',$data,array('parent_mobile' => $mobile));
        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile,));
      }
        $response = array('status' => true, 'message' => 'user logged in successfully', 'response' => array('childs' => $check_user,'parent' =>$check));
        $this->response($response);
    }

    /*token authentication*/

	/*parent login module*/
    public function parent_login_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}else if(empty($otp_confirmed)){
			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
		}else{
		
		$check_user = $this->user_model->get_parent_childs_details($mobile);
		//print_r($check_user);
			if(empty($check_user[0])){
				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
				$this->response($response);
			}else{
			    
			    
        if($otp_confirmed == 'no'){
            $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for school app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        }else if($otp_confirmed == 'yes'){
            
            $user_login = $this->user_model->get_parent_childs_details($mobile);
         
        if (empty($user_login)) {
           $response = array('status' => false, 'message' => 'Invalid mobile number !');
           $this->response($response);
            
        } else {
            
             $this->token_get($check_user,$mobile,$token);
           // $this->user_model->common_update("users",array("token"=>$token),array("id"=>$user_login[0]->id));
        //  $response = array('status' => true, 'message' => 'Login Successful!', 'response' => array('childs' => $user_login));
        }
        //$this->response($response);
            
        }
			    
			    
			    
			    
			    
			    
			  // $update =  $this->user_model->common_update("employees",array("token"=>$token),array("id"=>$check_user[0]['id']));
			  // echo $this->db->last_query();
			  //  echo $update;exit;
			   
			    
         // $response = array('status' => true, 'message' => 'Login Successful!', 'response' => $user_login);
				/*$response = array('status' => true, 'message' => 'User Loged In Successfully', 'response' => $check_user_login[0]);
				$this->response($response);*/
			}
		}
	}

	/*parent login module*/
	
	/* resend otp*/
	public function resend_otp_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
		
		$check_user = $this->user_model->get_parent_childs_details($mobile);
		//print_r($check_user);
			if(empty($check_user[0])){
				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
				$this->response($response);
			}else{
			    
			    
            $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for school app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        
       
			}
		}
	}
	
	/* resend otp*/

	/*child profile view*/

	public function child_profile_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			$get_child_profile = $this->user_model->get_child_profile($child_id);
    			//echo $this->db->last_query();exit;
    			if(empty($get_child_profile)){
    				$response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('child_profile' => $get_child_profile,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*child profile view*/
	
	/*parent child profile pic update*/
	public function parent_child_profile_pic_update_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($child_profile_image)){
            $response = array('status' => false, 'message' => 'Child profile image Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$get_child_detaiils = $this->user_model->common_fetch('students',array('id' => $child_id));
    			    if(!empty($child_profile_image))
    		        { 
    		            define('IMAGE_UPLOAD_DIR','assets/images/students/');
        				$img = str_replace('data:image/jpeg;base64','',$child_profile_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    if(!empty($get_child_detaiils[0]['student_image'])){
        				         unlink($get_child_detaiils[0]['student_image']);
        				    }
        				   
        					$data1 = array(
        						'student_image' => $user_file,
        						'updated_on' => date('Y-m-d H:i:s')
        						);
        					 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				} 
    			    }
    			   // $update = $this->user_model->common_update('students',$data,array('id' =>$child_id));
    			    
    			    
    				    			
            
            $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);

			
		  }
    	}
	
	    
	}
    /*parent child profile pic update*/
	
	/*parent profile view*/

	public function parent_profile_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			$get_child_profile = $this->user_model->get_child_profile($child_id);
    			//echo $this->db->last_query();exit;
    			if(empty($get_child_profile)){
    				$response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    $parent = array();
    			    if($get_child_profile[0]->father_mobile == $mobile){
    			        $parent[0]['parent_type'] = "father";
    			        $parent[0]['gender'] = "male";
    			        $parent[0]['name'] = $get_child_profile[0]->father_name;
    			        $parent[0]['mobile'] = $get_child_profile[0]->father_mobile;
    			        $parent[0]['email'] = $get_child_profile[0]->father_email;
    			        $parent[0]['image'] = base_url().$get_child_profile[0]->father_image;
    			        $parent[0]['occupation'] = $get_child_profile[0]->father_occupation;
    			        $parent[0]['office_designation'] = $get_child_profile[0]->father_office_designation;
    			        $parent[0]['office_address'] = $get_child_profile[0]->father_office_address;
    			        $parent[0]['annual_income'] = $get_child_profile[0]->father_annual_income;
    			        $parent[0]['address'] = $get_child_profile[0]->address;
    			        $parent[0]['city'] = $get_child_profile[0]->city;
    			        $parent[0]['pincode'] = $get_child_profile[0]->pincode;
    			        $parent[0]['spouse_name'] = $get_child_profile[0]->mother_name;
    			        $parent[0]['spouse_mobile'] = $get_child_profile[0]->mother_mobile;
    			        $parent[0]['dob'] = $get_child_profile[0]->father_dob;
    			        $parent[0]['anniversary_date'] = $get_child_profile[0]->anniversary_date;
    			        
    			    }else if($get_child_profile[0]->mother_mobile == $mobile){
    			        $parent[0]['parent_type'] = "mother";
    			        $parent[0]['gender'] = "female";
    			        $parent[0]['name'] = $get_child_profile[0]->mother_name;
    			        $parent[0]['mobile'] = $get_child_profile[0]->mother_mobile;
    			        $parent[0]['email'] = $get_child_profile[0]->mother_email;
    			        $parent[0]['image'] = base_url().$get_child_profile[0]->mother_image;
    			        $parent[0]['occupation'] = $get_child_profile[0]->mother_occupation;
    			        $parent[0]['office_designation'] = $get_child_profile[0]->mother_office_designation;
    			        $parent[0]['office_address'] = $get_child_profile[0]->mother_office_address;
    			        $parent[0]['annual_income'] = $get_child_profile[0]->mother_annual_income;
    			        $parent[0]['address'] = $get_child_profile[0]->address;
    			        $parent[0]['city'] = $get_child_profile[0]->city;
    			        $parent[0]['pincode'] = $get_child_profile[0]->pincode;
    			        $parent[0]['spouse_name'] = $get_child_profile[0]->father_name;
    			        $parent[0]['spouse_mobile'] = $get_child_profile[0]->father_mobile;
    			        $parent[0]['dob'] = $get_child_profile[0]->mother_dob;
    			        $parent[0]['anniversary_date'] = $get_child_profile[0]->anniversary_date;
    			    }
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('parent_profile' => $parent,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent profile view*/
	/*parenr profile update*/
	public function update_parent_profile_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($name)){
            $response = array('status' => false, 'message' => 'name Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($parent_type)){
            $response = array('status' => false, 'message' => 'parent type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			    if($parent_type == "father"){
    			        $data = array(
    			            'father_name' => $name,
    			            'father_email' => $email,
    			            'father_occupation' => $occupation,
    			            'father_office_designation' => $office_designation,
    			            'father_office_address' => $office_address,
    			            'father_dob' => $dob,
    			            'anniversary_date' => $anniversary_date,
    			            'mother_name' => $spouse_name,
    			            'mother_mobile' => $spouse_mobile,
    			            'updated_on' =>date('Y-m-d H:i:s')
    			            );
    			            $update = $this->user_model->common_update('students',$data,array('father_mobile' =>$mobile));
    			       
    			        
    			    }else if($parent_type == "mother"){
    			        $data = array(
    			            'mother_name' => $name,
    			            'mother_email' => $email,
    			            'mother_occupation' => $occupation,
    			            'mother_office_designation' => $office_designation,
    			            'mother_office_address' => $office_address,
    			            'mother_dob' => $dob,
    			            'anniversary_date' => $anniversary_date,
    			            'father_name' => $spouse_name,
    			            'father_mobile' => $spouse_mobile,
    			            'updated_on' =>date('Y-m-d H:i:s')
    			            );
    			            $update = $this->user_model->common_update('students',$data,array('mother_mobile' =>$mobile));
    			    }
    			    
    			    
    			    
    				$response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
    			
            }
			
		}
	}
	/*parenr profile update*/
	/*parent profile pic update*/
	public function parent_profile_pic_update_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($parent_type)){
            $response = array('status' => false, 'message' => 'parent type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($parent_profile_image)){
            $response = array('status' => false, 'message' => 'parent profile image Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$get_child_detaiils = $this->user_model->common_fetch('students',array('id' => $child_id));
    			    if($parent_type == "father"){
    			        
    			        if(!empty($parent_profile_image))
    		        { 
    		            define('IMAGE_UPLOAD_DIR','assets/images/fathers/');
        				$img = str_replace('data:image/jpeg;base64','',$parent_profile_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    unlink($get_child_detaiils[0]['father_image']);
        					$data1 = array(
        						'father_image' => $user_file,
        						'updated_on' => date('Y-m-d H:i:s')
        						);
        					 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				} 
    		        }
    			        
    			    }else if($parent_type == "mother"){
    			        if(!empty($parent_profile_image))
    		        { 
    		            define('IMAGE_UPLOAD_DIR','assets/images/mothers/');
        				$img = str_replace('data:image/jpeg;base64','',$parent_profile_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    unlink($get_child_detaiils[0]['mother_image']);
        					$data1 = array(
        						'mother_image' => $user_file,
        						'updated_on' => date('Y-m-d H:i:s')
        						);
        					 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				} 
    			    }
    			   // $update = $this->user_model->common_update('students',$data,array('id' =>$child_id));
    			    
    			    
    				    			
            }
            $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);

			
		  }
    	}
	
	    
	}
    /*parent profile pic update*/
    /*parent apply for leave*/
    public function patent_sent_message_post()
    {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($message_type)){
            $response = array('status' => false, 'message' => 'message type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			    if($message_type == "leave"){
    			        $data = array(
    			            'student_id' => $child_id,
    			            'message_type' => $message_type,
    			            'subject' => "Request for Leave",
    			            'message_to' => $message_to,
    			            'from_date' => $from_date,
    			            'to_date' => $to_date,
    			            'no_of_days' => $no_of_days,
    			            'remarks' => $remarks,
    			            'date'  => date('Y-m-d H:i:s'),
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			       
    			        
    			    }else if($message_type == "normal"){
    			        $image_link = '';
    			        if(!empty($image)){
    			            define('IMAGE_UPLOAD_DIR','assets/attachments/');
        				$img = str_replace('data:image/png;base64','',$image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				//     unlink($get_child_detaiils[0]['father_image']);
        				// 	$data1 = array(
        				// 		'father_image' => $user_file,
        				// 		'updated_on' => date('Y-m-d H:i:s')
        				// 		);
        				// 	 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				}else{
        				   // $image_link = '';
        				}
    			        }else{
    			            $user_file = "";
    			        }
    			      //  echo $user_file;
    			        $data = array(
    			            'student_id' => $child_id,
    			            'message_type' => $message_type,
    			            'subject' => $subject,
    			            'message_to' => $message_to,
    			           // 'from_date' => $from_date,
    			           // 'to_date' => $to_date,
    			           // 'no_of_days' => $no_of_days,
    			            'remarks' => $remarks,
    			            'attachment' => $user_file,
    			            'date'  => date('Y-m-d H:i:s'),
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			           // print_r($data);
    			            //exit;
    			    }
    			    $insert = $this->user_model->common_insert('parent_messages',$data);
    			    
    			    
    				$response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
    			
            }
			
		}
	}
    /*parent apply for leave*/
    
    /*parent sent messages view*/

	public function parent_view_sent_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$sent_message_id = "";
    			$fetch = $this->user_model->get_parent_sent_messages($child_id,$mobile,$sent_message_id);
    			    //echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('sent_messages' => $fetch,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent sent messages view*/
	
	/*parent view single sent message*/

	public function parent_view_single_sent_message_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($sent_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			$fetch = $this->user_model->get_parent_sent_messages($child_id,$mobile,$sent_message_id);
    			$get_replys = $this->user_model->get_parent_sent_replys($sent_message_id);
    			    //echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('sent_messages' => $fetch,
    				'replys' => $get_replys, 'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent view single sent message*/
	
	/* parent inbox messages */
	public function parent_inbox_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                    $sent_message_id = "";
    			$fetch = $this->user_model->get_parent_inbox_messages($child_id,$mobile,$sent_message_id);
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			   // echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	
	/* parent inbox messages */
	/*parent view inbox message*/
	public function parent_view_single_inbox_message_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_from)){
            $response = array('status' => false, 'message' => 'Inbox message from Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                if($inbox_message_from == "school_admin"){
                    $fetch = $this->user_model->get_parent_inbox_messages($child_id,$mobile,$inbox_message_id);
                   // echo $this->db->last_query();exit;
                }
                
                if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_message' => $fetch,
    				'parent' =>$check));
    				$this->response($response);
    			}
                
            }
        }
	}
	/*parent view inbox message*/
	
	/*parent read inbox message*/
	public function inbox_message_read_starred_archived_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_from)){
            $response = array('status' => false, 'message' => 'Inbox message from Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_status)){
            $response = array('status' => false, 'message' => 'Inbox message status Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                    $check = $this->user_model->common_fetch('parent_read_messages',array('student_id' => $child_id,
                    'message_type' => $inbox_message_from,'message_id' => $inbox_message_id));
                    if(empty($check)){
                            if($inbox_message_status == "read"){
                                $data = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'read_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "starred"){
                                $data = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "archived"){
                                $data = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }
                        $insert = $this->user_model->common_insert('parent_read_messages',$data);
                        
                    }else{
                        if($inbox_message_status == "read"){
                                $data1 = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'read_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "starred"){
                                $data1 = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "archived"){
                                $data1 = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "unarchived"){
                                $data1 = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "unstarred"){
                                $data1 = array(
            			            'student_id' => $child_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }
                           $update = $this->user_model->common_update('parent_read_messages',$data1,array('student_id' => $child_id,
                    'message_type' => $inbox_message_from,'message_id' => $inbox_message_id)); 
                        
                    }
                    
                    
                    $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
        				$this->response($response);
                  
    			           // print_r($data);
    			            //exit;
    			 }
    			    
    			    
    			    
    				
                
            }
        
	}
	/*parent read inbox message*/
	
	/*parent mark as all read messages*/
	public function parent_mark_as_all_read_messages_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_messages)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                 
                    if(!empty($inbox_messages)){
                        foreach($inbox_messages as $inbox){
                            $check = $this->user_model->common_fetch('parent_read_messages',array('student_id' => $child_id,
                    'message_type' => $inbox['from'],'message_id' => $inbox['id']));
                    
                            if(!empty($check)){
                                $data = array(
            			          //  'student_id' => $child_id,
            			          //  'message_type' => $inbox['from'],
            			         //   'message_id' => $inbox['id'],
            			            'read_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
            			            $update = $this->user_model->common_update('parent_read_messages',$data,array('student_id' => $child_id,
                                    'message_type' => $inbox['from'],'message_id' => $inbox['id']));
                            }else{
                                $data1 = array(
            			              'student_id' => $child_id,
            			              'message_type' => $inbox['from'],
            			              'message_id' => $inbox['id'],
            			              'read_message' => "yes",
            			              'created_on' =>date('Y-m-d H:i:s')
            			            );
            			            $insert = $this->user_model->common_insert('parent_read_messages',$data1);
                            }
                        }
                            
                        
                        
                    }
                    
                    
                    
                    $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
        				$this->response($response);
                  
    			           // print_r($data);
    			            //exit;
    			 }
    			    
    			    
    			    
    				
                
            }
        
	}
	/*parent mark as all read messages*/
	
	/* parent search inbox messages */
	public function parent_search_inbox_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($search_subject)){
            $response = array('status' => false, 'message' => 'Search Subject Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                    
    			$fetch = $this->user_model->get_parent_search_inbox_messages($child_id,$mobile,$search_subject);
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			   // echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	
	/* parent search inbox messages */
	/*parent child album details*/
	public function paernt_view_child_album_details_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($album_type)){
            $response = array('status' => false, 'message' => 'Album Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $album_id = '';
                    
    			$fetch = $this->user_model->get_parent_child_albums($child_id,$album_type,$album_id);
    		//	echo $this->db->last_query();exit;
    			//echo "<pre>";print_r($fetch);exit;
    			$data = array();
               if(!empty($fetch)){
                   $i = 0; 
                   foreach($fetch as $album){
                      
                       $fetch_album_content1 = $this->user_model->common_fetch('album_content',array('album_id' => $album['id']));
                      $fetch_album_content = $this->user_model->fetch_album_content_for_all($album['id']);
                       $data[$i]['id'] = $album['id'];
                       $data[$i]['title'] = $album['title'];
                       $data[$i]['album_type'] = $album['album_type'];
                       $data[$i]['album_count'] = count($fetch_album_content1);
                       $data[$i]['album_content'] = $fetch_album_content;
                       
                       $i++;
                   }
                   
               }
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('albums' => $data,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent child album details*/
	
	/*parent child single album details*/
	public function paernt_view_child_single_album_details_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $album_type = "";
                    
    			$fetch = $this->user_model->get_parent_child_albums($child_id,$album_type,$album_id);
    		//	echo $this->db->last_query();exit;
    			//echo "<pre>";print_r($fetch);exit;
    			$data = array();
               if(!empty($fetch)){
                   $i = 0; 
                   foreach($fetch as $album){
                      
                       $fetch_album_content = $this->user_model->common_fetch('album_content',array('album_id' => $album['id']));
                     // $fetch_album_content = $this->user_model->fetch_album_content_for_homepage($album['id']);
                       $data[$i]['id'] = $album['id'];
                       $data[$i]['title'] = $album['title'];
                       $data[$i]['album_type'] = $album['album_type'];
                       $data[$i]['album_count'] = count($fetch_album_content);
                       $data[$i]['album_content'] = $fetch_album_content;
                       
                       $i++;
                   }
                   
               }
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('albums' => $data,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent child single album details*/
	
	
	/*parent send suggesions*/
    public function patent_sent_suggesions_post()
    {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($suggestion)){
            $response = array('status' => false, 'message' => 'Suggestion Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($remarks)){
            $response = array('status' => false, 'message' => 'Remarks Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($suggestion)){
            $response = array('status' => false, 'message' => 'Suggestion Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   
    			        $image_link = '';
    			        if(!empty($attachment)){
    			            define('IMAGE_UPLOAD_DIR','assets/parent_suggestions/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				//     unlink($get_child_detaiils[0]['father_image']);
        				// 	$data1 = array(
        				// 		'father_image' => $user_file,
        				// 		'updated_on' => date('Y-m-d H:i:s')
        				// 		);
        				// 	 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				}else{
        				   // $image_link = '';
        				}
    			        }else{
    			            $user_file = "";
    			        }
    			      //  echo $user_file;
    			        $data = array(
    			            'student_id' => $child_id,
    			            'parent_mobile' => $mobile,
    			            'suggestion' => $suggestion,
    			            'remarks' => $remarks,
    			            'attachment' => $user_file,
    			            'date'  => date('Y-m-d H:i:s'),
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			           // print_r($data);
    			            //exit;
    			   
    			    $insert = $this->user_model->common_insert('parent_suggestions',$data);
    			    
    			    
    				$response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
    			
            }
			
		}
	}
    /*parent send suggesions*/
    
    /* parent view child meal planner*/
    public function parent_view_child_planner_post()
    {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($meal_type)){
            $response = array('status' => false, 'message' => 'Meal Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_parent_child_palnner($child_id,$date,$meal_type);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('mealplanner' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
    /* parent view child meal planner*/
    /*parent view about us details */
    public function parent_view_about_us_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_parent_school_aboutus($child_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('aboutus' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*parent view about us details */
	/*parent view terms and conditions details */
    public function parent_view_terms_and_conditions_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_parent_school_terms_condition($child_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('termsandconditions' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*parent view terms and conditions details */
	/*parent view terms and conditions details */
    public function parent_view_privacy_policy_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_parent_school_privacy_policy($child_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('privacypolicy' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*parent view terms and conditions details */
	/*parent view parent home page details*/
	public function view_homepage_details_post() 
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			/* album details*/
    			   $get_album = $this->user_model->get_parent_child_albums_for_homepage($child_id,$album_type = "all");
    		//	echo   $this->db->last_query();exit;
    			   $dataalbum = array();
    			    if(!empty($get_album)){
                   $i = 0; 
                   foreach($get_album as $album){
                       $fetch_album_content = $this->user_model->fetch_album_content_for_homepage($album['id']);
                       $dataalbum[$i]['title'] = $album['title'];
                       $dataalbum[$i]['album_type'] = $album['album_type'];
                       $dataalbum[$i]['album_count'] = count($fetch_album_content);
                       $dataalbum[$i]['album_content'] = $fetch_album_content;
                       
                       $i++;
                   }
                   
               }
               
               	/* album details*/
               	
               	/* consent details */
               	$get_consent = $this->user_model->get_parent_child_consent_deatils_for_homepage($child_id);
              // 	echo $this->db->last_query();exit;
               	/* consent details */
               $get_promotions = $this->user_model->get_school_promotional_details($school_id);
    			
        			 /*school details */ 
        			 $school_data = $this->user_model->get_child_school_details($child_id);
        			  /*school details */ 
    			    
    			 

    			//  echo $this->db->last_query();exit;
    			    
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			            'school_details' => $school_data, 'promotions' => $get_promotions, 'albums' => $dataalbum, 
    			            'consents' => $get_consent,	'parent' =>$check));
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/*parent view parent home page details*/
	
		/*parent view parent home page messages details*/
	public function view_homepage_messages_details_post() 
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    		
               
    				/* inbox messages details*/
    			     $get_messages = $this->user_model->get_parent_inbox_messages_homepage($child_id,$mobile);
    			     
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($get_messages)){
        			    $i=0;
        			    foreach($get_messages as $fff){
        			       
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['staff_name'] = "School Admin";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			      
        			    }
        			}
        			
        			/* inbox messages details*/
    			//  echo $this->db->last_query();exit;
    			    
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'messages' => $data,	'parent' =>$check));
    				$this->response($response);
    			    
    				
    			
            }
			
		}
	}
	/*parent view parent home page details*/
	
	/*parent childrens details*/
	public function parent_view_children_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $check_user = $this->user_model->get_parent_childs_details($mobile);
                if(empty($check_user))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                     $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'childrens' => $check_user,	'parent' =>$check));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/*parent childrens details*/
	
		/*parent children dairy details*/
	public function parent_view_children_dairy_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'student ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $get_child_dairy = $this->user_model->get_student_dairy_details($child_id,$date);
              //  echo $this->db->last_query();exit;
                if(empty($get_child_dairy))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    foreach($get_child_dairy as $dairy){
                        $check = $this->user_model->common_fetch('students_dairy_delivery_report',array('dairy_id' => $dairy['id'],'student_id' => $child_id));
                       if(empty($check)){
                            $data = array(
                            'dairy_id' => $dairy['id'],
                            'student_id' => $child_id,
                            'created_on' => date('Y-m-d H:i:s')
                            );
                            $this->user_model->common_insert('students_dairy_delivery_report',$data);
                       }
                       
                    }
                     $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'dairy_details' => $get_child_dairy,	'parent' =>$check));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/*parent children dairy details*/
	
		/* parent child calender list details*/
	public function parent_child_claender_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $calender_id = '';
                $data = $this->user_model->get_parent_child_calender_deatils($child_id,$date,$calender_id);
             //   echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'calender_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* parent child calender list details*/
	
			/* parent child view single calender  details*/
	public function parent_child_view_single_claender_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $date = '';
                $data = $this->user_model->get_parent_child_calender_deatils($child_id,$date,$calender_id);
                $atatchments = $this->user_model->common_fetch('school_calender_attachments',array('calender_id' => $calender_id));
             //   echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'calender_details' => $data, 'attachments' => $atatchments));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* parent child view single calender  details*/
	
	/* parent child consent list details*/
	public function parent_child_consent_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($date)){
        //     $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $consent_id = '';
            
                $data = $this->user_model->get_parent_child_consent_deatils($child_id,$date,$consent_id);
             //   echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'consent_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* parent child consent list details*/
	
	/* parent child consent list details*/
	public function parent_child_view_single_consent_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Consent ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $date = '';
                $data = $this->user_model->get_parent_child_consent_deatils($child_id,$date,$consent_id);
                $atatchments = $this->user_model->common_fetch('school_consent_attachments',array('consent_id' => $consent_id));
            //   echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'consent_details' => $data, 'attachments' => $atatchments));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* parent child view single consent  details*/
	
	/* parent reply to message to admin */
	public function reply_to_message_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message_type)){
            $response = array('status' => false, 'message' => 'Meesage Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                 $image_link = '';
    			        if(!empty($attachment)){
    			            define('IMAGE_UPLOAD_DIR','assets/reply_attachments/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
    			        
                  if($message_type == "school_admin"){
                     
                      $data_message = array(
                          'message_id' => $message_id,
                          'sender_type' => 'parent',
                          'sender_id' => $child_id,
                          'reply_message' => $reply_message,
                          'attachment' => $image_link,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('replys_for_school_admin_messages',$data_message);
                   //   echo $this->db->last_query();exit;
                  }else if($message_type == "teacher"){
                      
                  }
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/* parent reply to message to admin */
	
	/*parent inbox messages replys */
	public function parent_inbox_messages_replys_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // if($message_type == "school_admin"){
                    $get_replys = $this->user_model->get_parent_inbox_replys($message_id);
                    if(empty($get_replys)){
                        $response = array('status' => true, 'message' => 'Empty Data', 'response' => array('replys' => array()));
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('replys' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/*parent inbox messages replys */
	
	/*parent sent messages replys */
	public function parent_sent_messages_replys_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // if($message_type == "school_admin"){
                    $get_replys = $this->user_model->get_parent_sent_replys($message_id);
                    if(empty($get_replys)){
                        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array('replys' => array()));
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('replys' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/*parent sent messages replys */
	
	/*parent child view day care details */
	public function parent_view_child_daycare_reports_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $get_daycare_reports = $this->user_model->get_student_daycare_reports($child_id,$date);
                if(empty($get_daycare_reports)){
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array('replys' => array()));
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('daycare' => $get_daycare_reports));
    				$this->response($response); 
                }
            }
        }
	}
	/*parent child view day care details */
	
	
	/* all schools details*/
	public function parent_all_schools_info_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $fetch = $this->user_model->common_fetch('schools_info',array('school_id' => $school_id));
                if(empty($fetch)){
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array('schools' => array()));
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('schools' => $fetch));
    				$this->response($response); 
                }
            }
        }
	}
	/* all schools details*/
	
	/* parent child not listed*/
	public function parent_child_not_listed_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                      $data = array(
                          'school_id' => $school_id,
                          'parent_mobile' => $mobile,
                          'student_id' => $child_id,
                          'student_school_id' => $student_school_id,
                          'child_name' => $name,
                          'child_class_session' => $class_session,
                          'father_mobile' => $father_mobile,
                          'mother_mobile' => $mother_mobile,
                          'created_on' => date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_child_not_listed',$data);
                
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => '');
    				$this->response($response); 
                
            }
        }
	}
	/* parent child not listed*/

	/* parent add child*/
	public function parent_add_child_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($child_id)){
            $response = array('status' => false, 'message' => 'Child ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                      $data = array(
                          'school_id' => $school_id,
                          'parent_mobile' => $mobile,
                          'student_id' => $child_id,
                          'name' => $name,
                          'dob' => $dob,
                          'school' => $school,
                          'created_on' => date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_parent_add_child',$data);
                
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => '');
    				$this->response($response); 
                
            }
        }
	}
	/* parent add child */
	
	
	
	
	/*----------------------- parent apis end -------------------------*/
	
	
	
	
	
	/*---------------------- teacher apis start----------------------------- /*
	
	/*token authentication*/
    public function teacher_token_get($check_user,$mobile,$token)
    {
        $key = "schoolappkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $mobile,
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
      //$check = $this->user_model->common_fetch('staff',array('employee_mobile' => $mobile));
     
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('staff',$data,array('employee_mobile' => $mobile));
      $check = $this->user_model->common_fetch('staff',array('employee_mobile' => $mobile));
        $response = array('status' => true, 'message' => 'user logged in successfully', 'response' => array('teacher_details' => $check));
        $this->response($response);
    }

    /*token authentication*/

	/*parent login module*/
    public function teacher_login_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}else if(empty($otp_confirmed)){
			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
		}else{
		
		$check_user = $this->user_model->get_staff_details($mobile);
		//print_r($check_user);
			if(empty($check_user[0])){
				$response = array('status' => false, 'message' => 'No Teacher With These Details', 'response' => (object)array());
				$this->response($response);
			}else{
			    
			    
        if($otp_confirmed == 'no'){
            if($check_user[0]['status'] == 0){
                $response = array('status' => false, 'message' => 'Your profile in InActive..!', 'response' => array('otp' => "$otp") );
                $this->response($response);
          
            }
            $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for school app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        }else if($otp_confirmed == 'yes'){
            
            //$user_login = $this->user_model->get_parent_childs_details($mobile);
         
        if (empty($check_user)) {
           $response = array('status' => false, 'message' => 'Invalid mobile number !');
           $this->response($response);
            
        } else {
            
             $this->teacher_token_get($check_user,$mobile,$token);
           // $this->user_model->common_update("users",array("token"=>$token),array("id"=>$user_login[0]->id));
        //  $response = array('status' => true, 'message' => 'Login Successful!', 'response' => array('childs' => $user_login));
        }
        //$this->response($response);
            
        }
        
        
			    
			    
			    
			    
			    
			    
			  // $update =  $this->user_model->common_update("employees",array("token"=>$token),array("id"=>$check_user[0]['id']));
			  // echo $this->db->last_query();
			  //  echo $update;exit;
			   
			    
         // $response = array('status' => true, 'message' => 'Login Successful!', 'response' => $user_login);
				/*$response = array('status' => true, 'message' => 'User Loged In Successfully', 'response' => $check_user_login[0]);
				$this->response($response);*/
			}
		}
	}

	/*parent login module*/
	
		/* resend otp*/
	public function teacher_resend_otp_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
		
		$check_user = $this->user_model->get_staff_details($mobile);
		//print_r($check_user);
			if(empty($check_user[0])){
				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
				$this->response($response);
			}else{
			    
			    
            $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for school app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
        
       
			}
		}
	}
	
	/* resend otp*/
	
	/* teacher access details */
	public function teacher_view_access_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $data = $this->user_model->common_fetch('staff_rights',array('staff_id' => $teacher_id));
              //  echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'access_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	
	/* teacher access details */
	
	/* teacher classes details */
	public function teacher_view_classes_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $data = $this->user_model->get_teacher_class_details($teacher_id);
              //  echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'classes' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	
	/* teacher classes details */
	
	/* class teacher dairy update deatils*/
	public function class_taecher_view_students_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_type)){
            $response = array('status' => false, 'message' => 'Student Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == "search" && !empty($search_key)){
                    $data = $this->user_model->get_teacher_class_search_stuednts_details($teacher_id,$student_type,$class_id,$search_key);
                }else if($type == "" && empty($search_key)){
                  // $staff_id = '';
                    $data = $this->user_model->get_teacher_class_stuednts_details($teacher_id,$student_type,$class_id); 
                }else{
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }
                
            
               // $data = $this->user_model->get_teacher_class_stuednts_details($teacher_id,$student_type,$class_id);
              //  echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'students' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* class teacher students deatils*/
	
	
	/* class teacher dairy update deatils*/
	public function class_taecher_view_all_students_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_type)){
            $response = array('status' => false, 'message' => 'Student Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == "search" && !empty($search_key)){
                    $data = $this->user_model->get_teacher_class_search_all_stuednts_details($teacher_id,$student_type,$class_id,$search_key);
                }else if($type == "" && empty($search_key)){
                  // $staff_id = '';
                    $data = $this->user_model->get_teacher_class_all_stuednts_details($teacher_id,$student_type,$class_id); 
                }else{
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }
                
            
               // $data = $this->user_model->get_teacher_class_stuednts_details($teacher_id,$student_type,$class_id);
              //  echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'students' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* class teacher students deatils*/
	
	
	
		/* class teacher dairy update deatils*/
	public function class_taecher_view_students_dairy_remarks_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($type)){
        //     $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $data = $this->user_model->get_teacher_class_stuednts_dairy_remarks_details($teacher_id,$class_id,$date,$type);
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'students' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* class teacher students deatils*/
	
		/* class teacher dairy deatils*/
	public function class_taecher_dairy_update_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Work Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($details)){
        //     $response = array('status' => false, 'message' => 'Details Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        // else if(empty($student_id)){
        //     $response = array('status' => false, 'message' => 'Student ID Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $file_link = "";
                if(!empty($attachment_type) && !empty($attachment)){
                  
                    if(!empty($attachment)){
                         /// echo "<pre>";
                  // print_r($attachement);exit;
    			            define('IMAGE_UPLOAD_DIR','assets/student_dairy/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
    
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				if($attachment_type == "image"){
        				    	$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				}else{
        				    	$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.pdf';
        				}
        		
        				$success = file_put_contents($user_file,$user_data); 
				//  echo "<pre>";
    //                 print_r($success);exit;
        				if($success){
        				    $file_link = $user_file;
        				//     unlink($get_child_detaiils[0]['father_image']);
        				// 	$data1 = array(
        				// 		'father_image' => $user_file,
        				// 		'updated_on' => date('Y-m-d H:i:s')
        				// 		);
        				// 	 $this->user_model->common_update('students',$data1,array('id' => $child_id));
        				}else{
        				  // $image_link = '';
        				}
    			        }
                }
             
//              $file_link = "";
//     			  if (!empty($attachment)) {
//     define('UPLOAD_DIR', 'assets/parent_suggestions/');

//     // Ensure upload directory exists
//     if (!is_dir(UPLOAD_DIR)) {
//         mkdir(UPLOAD_DIR, 0777, true);
//     }

//     // Check if Base64 contains MIME type (e.g., "data:image/png;base64,...")
//     if (preg_match('/^data:([\w\/]+);base64,/', $attachment, $matches)) {
//         $mimeType = $matches[1]; // Extract MIME type
//         $attachment = preg_replace('#^data:[\w\/]+;base64,#', '', $attachment);
//     } else {
//         // Assume it's a raw Base64 image if no MIME type is found
//         $mimeType = null;
//     }

//     // Decode Base64 string
//     $attachment = str_replace(' ', '+', $attachment);
//     $decodedData = base64_decode($attachment);

//     // Verify successful decoding
//     if ($decodedData === false) {
//         log_message('error', 'Base64 decoding failed.');
//         echo json_encode(['status' => false, 'message' => 'Invalid Base64 data.']);
//         exit;
//     }

//     // If MIME type is missing, detect it from binary data
//     if (!$mimeType) {
//         $finfo = finfo_open(FILEINFO_MIME_TYPE);
//         $mimeType = finfo_buffer($finfo, $decodedData);
//         finfo_close($finfo);
//     }
    
    

//     // Map MIME types to file extensions
//     $mimeMap = [
//         'image/jpeg' => 'jpg',
//         'image/png' => 'png',
//         'image/gif' => 'gif',
//         'application/pdf' => 'pdf',
//         'application/msword' => 'doc',
//         'application/vnd.openxmlformats-officedocument.wordprocessingml.document' => 'docx',
//         'application/vnd.ms-excel' => 'xls',
//         'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => 'xlsx',
//         'text/plain' => 'txt'
//     ];

//     // Validate file type
//     if (isset($mimeMap[$mimeType])) {
//         $fileExt = $mimeMap[$mimeType]; // Get the correct file extension
//         $newFileName = uniqid() . '.' . $fileExt;
//         $filePath = UPLOAD_DIR . $newFileName;

//         // Save file
//         if (file_put_contents($filePath, $decodedData)) {
//             $file_link = base_url($filePath);
//             echo json_encode(['status' => true, 'message' => 'File uploaded successfully', 'file_url' => $file_link]);
//         } else {
//             log_message('error', 'File writing failed.');
//             echo json_encode(['status' => false, 'message' => 'File saving failed.']);
//         }
//     } else {
//         log_message('error', 'Unsupported file type: ' . $mimeType);
//         echo json_encode(['status' => false, 'message' => 'Unsupported file type.']);
//     }
// } else {
//     echo json_encode(['status' => false, 'message' => 'No file provided.']);
// }


                    
               
            
              if($student_id == "all"){
                  
                 $check_dairy = $this->user_model->common_fetch('students_dairy_details',array('teacher_id' => $teacher_id,
                 'date' => $date, 'class_id' => $class_id, 'type' => $type, 'student_id' => 0));
                 if(empty($check_dairy))
                 {
                     $data_dairy_in = array(
                         'teacher_id' => $teacher_id,
                         'date' => $date, 
                         'class_id' => $class_id, 
                         'type' => $type, 
                         'student_id' => 0,
                         'details' => $details,
                         'attachment_type' => $attachment_type,
                         'attachment' => $file_link,
                         'created_on' => date('Y-m-d')
                         );
                         $insert = $this->user_model->common_insert('students_dairy_details',$data_dairy_in);
                 }else{
                     $data_dairy_in1 = array(
                         'teacher_id' => $teacher_id,
                         'date' => $date, 
                         'class_id' => $class_id, 
                         'type' => $type, 
                         'student_id' => 0,
                         'details' => $details,
                         'attachment_type' => $attachment_type,
                         'attachment' => $file_link,
                         'updated_on' => date('Y-m-d')
                         );
                     $insert = $this->user_model->common_update('students_dairy_details',$data_dairy_in1,array('teacher_id' => $teacher_id,
                 'date' => $date, 'class_id' => $class_id, 'type' => $type, 'student_id' => 0));
                 }
              }else{
                  $check_dairy = $this->user_model->common_fetch('students_dairy_details',array('teacher_id' => $teacher_id,
                 'date' => $date, 'class_id' => $class_id, 'type' => $type, 'student_id' => $student_id));
                 if(empty($check_dairy))
                 {
                     $data_dairy_in = array(
                         'teacher_id' => $teacher_id,
                         'date' => $date, 
                         'class_id' => $class_id, 
                         'type' => $type, 
                         'student_id' => $student_id,
                         'details' => $details,
                         'remarks' => $remarks,
                         'attachment_type' => $attachment_type,
                         'attachment' => $file_link,
                         'created_on' => date('Y-m-d')
                         );
                         $insert = $this->user_model->common_insert('students_dairy_details',$data_dairy_in);
                 }else{
                     $data_dairy_in1 = array(
                         'teacher_id' => $teacher_id,
                         'date' => $date, 
                         'class_id' => $class_id, 
                         'type' => $type, 
                         'student_id' => $student_id,
                         'details' => $details,
                         'remarks' => $remarks,
                         'attachment_type' => $attachment_type,
                         'attachment' => $file_link,
                         'updated_on' => date('Y-m-d')
                         );
                     $insert = $this->user_model->common_update('students_dairy_details',$data_dairy_in1,array('teacher_id' => $teacher_id,
                 'date' => $date, 'class_id' => $class_id, 'type' => $type, 'student_id' => $student_id));
                 }
              }
             
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
    			    
                
            }
        }
	}
	/* class teacher dairy update deatils*/
	
	/* teacher view created dairy details */
	public function teacher_view_dairy_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($details)){
        //     $response = array('status' => false, 'message' => 'Details Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        // else if(empty($student_id)){
        //     $response = array('status' => false, 'message' => 'Student ID Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
             
             
                  
                 $check_dairy = $this->user_model->common_fetch('students_dairy_details',array('teacher_id' => $teacher_id,
                 'date' => $date, 'class_id' => $class_id));
                 if(empty($check_dairy)){
                       $response = array('status' => true, 'message' => 'Empty Data ', 'response' => (object)array());
    				$this->response($response);
                 }else{
                       $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('dairy_details' => $check_dairy));
    				$this->response($response);
                 }
            }
        }
	}
	/* teacher view created dairy details */
	
		/* teacher delete  dairy details */
	public function teacher_delete_dairy_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($dairy_id)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                 $check_dairy = $this->user_model->common_fetch('students_dairy_details',array('id' => $dairy_id));
                 if(empty($check_dairy)){
                       $response = array('status' => true, 'message' => 'Empty Data ', 'response' => (object)array());
    				$this->response($response);
                 }else{
                     if(!empty($check_dairy[0]->attachment)){
                         unlink($check_dairy[0]->attachment);
                     }
                     $delete = $this->user_model->common_permanent_delete('students_dairy_details',array('id' => $dairy_id));
                     
                       $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('dairy_details' => $check_dairy));
    				$this->response($response);
                 }
            }
        }
	}
	/* teacher delete dairy details */
	
	/* teacher view  dairy delivery report details */
	public function teacher_view_dairy_delivery_report_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($dairy_id)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                 $check_dairy = $this->user_model->common_fetch('students_dairy_details',array('id' => $dairy_id));
                 if(empty($check_dairy)){
                       $response = array('status' => true, 'message' => 'Empty Data ', 'response' => (object)array());
    				$this->response($response);
                 }else{
                     if($check_dairy[0]['student_id'] == 0){
                         $get_data = $this->user_model->dairy_delivery_report_of_all_student($dairy_id,$check_dairy[0]['class_id']);
                     }else{
                         $get_data = $this->user_model->dairy_delivery_report_of_student($dairy_id,$check_dairy[0]['student_id']);
                     }
                     
                       $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('delivery_report' => $get_data));
    				$this->response($response);
                 }
            }
        }
	}
	/* teacher view dairy delivery report details */
	
	
	/*teacher updating  attendance */
	public function teacher_updating_attendance_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($qrcode_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attendance)){
            $response = array('status' => false, 'message' => 'Attendance Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($mark_as)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($attendance == "staff"){
                    $fetch_staff = $this->user_model->common_fetch('staff',array('qrcode_id' => $qrcode_id, 'delete_status' => 1));
                    if(!empty($fetch_staff)){
                        $check_staff = $this->user_model->common_fetch('staff_attendance',array('qrcode_id' => $qrcode_id, 'delete_status' => 1));
                    }
                }else if($attendance == "student"){
                    $fetch_student = $this->user_model->common_fetch('students',array('qrcode_id' => $qrcode_id, 'delete_status' => 1));
                    if(empty($fetch_student)){
                        $response = array('status' => false, 'message' => 'Invalid QR Code', 'response' => array());
    				$this->response($response);
                    }
                   // print_r($fetch_student);exit;
                    $check_attendance = $this->user_model->common_fetch('students_attendance',array('student_id' => $fetch_student[0]['id'],'date' => date('Y-m-d')));
                    if($mark_as == "in" && empty($check_attendance)){
                        $data = array(
                            'student_id' => $fetch_student[0]['id'],
                            'date' => date('Y-m-d'),
                            'in_time' => date('H:i:s'),
                            'teacher_id' => $teacher_id,
                            'created_on' => date('Y-m-d H:i:s'),
                            );
                            $insert = $this->user_model->common_insert('students_attendance',$data);
                    }else if($mark_as == "in" && !empty($check_attendance)){
                         $response = array('status' => false, 'message' => 'Student In Time Already Added', 'response' => array());
    				$this->response($response);
                    }else if($mark_as == "out" && !empty($check_attendance)){
                          $data1 = array(
                           // 'student_id' => $student_id,
                          //  'date' => date('Y-m-d'),
                            'out_time' => date('H:i:s'),
                            'teacher_id' => $teacher_id,
                            'updated_on' => date('Y-m-d H:i:s'),
                            );
                            $upate = $this->user_model->common_update('students_attendance',$data1,array('student_id' => $fetch_student[0]['id'],'date' => date('Y-m-d')));
                        //echo $this->db->last_query();exit;
                    }
                }else if($attendance == "cab"){
                    
                }
                
                 $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher updating  attendance */
	
	/* school total staff details */
	public function school_staff_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $data = $this->user_model->common_fetch('staff',array('school_id' => $school_id));
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'staff_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
 	/* school total staff details */
	/*teacher creating calender */
	public function teacher_create_calender_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_ids)){
            $response = array('status' => false, 'message' => 'Attendance Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($subject)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($time)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                   // print_r($fetch_student);exit;
                        $data = array(
                            'school_id' => $school_id,
                            'teacher_id' => $teacher_id,
                            'class_ids' => trim($class_ids),
                            'staff_ids' => trim($staff_ids),
                            'student_ids' => trim($student_ids),
                          //  'staff_ids' => $staff_ids,
                            'group_ids' => trim($group_ids),
                            'subject' => $subject,
                            'date' => $date,
                            'time' => $time,
                            'advance_options' => $advance_options,
                            'details' => $details,
                            'location' => $location,
                            // 'attachment_type' => $attachment_type,
                            // 'attachment' => $image_link,
                            'created_on' => date('Y-m-d H:i:s'),
                            );
                            $insert = $this->user_model->common_insert('school_calender_details',$data);
                            if($insert){
                                
                               
    			        if(!empty($attachment)){
    			            
    			            $images = explode(",",$attachment);
                            foreach($images as $imgsss){ 
                               if(!empty($imgsss)){
                                   define('IMAGE_UPLOAD_DIR','assets/school_calenders/');
                    				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				   // $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        				    $data1 = array(
                        						'calender_id' => $insert,
                        						'attachment' =>$user_file,
                        						'created_on' => date('Y-m-d H:i:s')
                        						);
                        					 $this->user_model->common_insert('school_calender_attachments',$data1);
                    				}
                               } 
                                
    			            
                            }//foreach
                            
                            
    			        }
                                
                            }
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher creating calender */
	
	/* teacher calender list details*/
	public function teacher_claender_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $calender_id = '';
                $data = $this->user_model->get_teacher_calender_deatils($teacher_id,$date,$calender_id);
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'calender_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher calender list details*/
	/* teacher view single calender  details*/
	public function teacher_view_single_claender_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $date = '';
                $data = $this->user_model->get_teacher_calender_deatils($teacher_id,$date,$calender_id);
                $atatchments = $this->user_model->common_fetch('school_calender_attachments',array('calender_id' => $calender_id));
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'calender_details' => $data, 'attachments' => $atatchments));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher view single calender  details*/
	/*teacher update calender */
	public function teacher_update_calender_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_ids)){
            $response = array('status' => false, 'message' => 'Attendance Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($subject)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Mark As Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($time)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_calender_details',array('id' => $calender_id));
                   // print_r($fetch_student);exit;
                   
    			        
                
                        $data = array(
                            'school_id' => $school_id,
                            'teacher_id' => $teacher_id,
                            'class_ids' => $class_ids,
                            'staff_ids' => $staff_ids,
                            'student_ids' => $student_ids,
                            'staff_ids' => $staff_ids,
                            'group_ids' => $group_ids,
                            'subject' => $subject,
                            'date' => $date,
                            'time' => $time,
                            'advance_options' => $advance_options,
                            'details' => $details,
                            'location' => $location,
                            // 'attachment_type' => $attachment_type,
                            // 'attachment' => $image_link,
                            'updated_on' => date('Y-m-d H:i:s'),
                            );
                            $update = $this->user_model->common_update('school_calender_details',$data,array('id' => $calender_id));
                            if($update){
                                
                               
    			     //   if(!empty($attachment)){
    			            
    			     //       $images = explode(",",$attachment);
            //                 foreach($images as $imgsss){ 
                                
                                
    			     //       define('IMAGE_UPLOAD_DIR','assets/school_calenders/');
        				// $img = str_replace('data:image/jpeg;base64','',$imgsss);
        				// $img = str_replace(' ','+',$img);
        				// $user_data = base64_decode($img);
        				// $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				// $success = file_put_contents($user_file,$user_data); 
				
        				// if($success){
        				//   // $image_link = $user_file;
        				// //     unlink($get_child_detaiils[0]['father_image']);
        				// 	$data1 = array(
        				// 		'calender_id' => $calender_id,
        				// 		'attachment' =>$user_file,
        				// 		'created_on' => date('Y-m-d H:i:s')
        				// 		);
        				// 	 $this->user_model->common_insert('school_calender_attachments',$data1);
        				// }
            //                 }
    			     //   }
                                
                            }
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher update calender */
	
		/*teacher delete calender */
	public function teacher_delete_calender_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_calender_attachments',array('calender_id' => $calender_id));
                  
            				    if(!empty($get_clander_details)){
            				        foreach($get_clander_details as $cal){
            				            unlink($cal[0]['attachment']);
            				        }
            				        
            				    }
            		
                            $delete = $this->user_model->common_permanent_delete('school_calender_attachments',array('calender_id' => $calender_id));
            		
                            $delete = $this->user_model->common_permanent_delete('school_calender_details',array('id' => $calender_id));
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher delete calender */
	
	/*teacher delete calender attachment*/
	public function teacher_delete_calender_attachment_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachment_id)){
            $response = array('status' => false, 'message' => 'Attachment ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_calender_attachments',array('id' => $attachment_id));
                  
            				    if(!empty($get_clander_details[0]['attachment'])){
            				        unlink($get_clander_details[0]['attachment']);
            				    }
            		
                            $delete = $this->user_model->common_permanent_delete('school_calender_attachments',array('id' => $attachment_id));
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher delete calender attachment*/
	/*teacher update calender attachment */
	public function teacher_update_calender_attachment_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($calender_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_calender_details',array('id' => $calender_id));
                   // print_r($fetch_student);exit;
                               
    			        if(!empty($attachment)){
    			            
    			            $images = explode(",",$attachment);
                            foreach($images as $imgsss){ 
                                
                                
    			            define('IMAGE_UPLOAD_DIR','assets/school_calenders/');
        				$img = str_replace('data:image/jpeg;base64','',$imgsss);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				   // $image_link = $user_file;
        				//     unlink($get_child_detaiils[0]['father_image']);
        					$data1 = array(
        						'calender_id' => $calender_id,
        						'attachment' =>$user_file,
        						'created_on' => date('Y-m-d H:i:s')
        						);
        					 $this->user_model->common_insert('school_calender_attachments',$data1);
        				}
                            }
    			        }
                                
                            
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher update calender attachment */
	
	
	
	/*teacher creating consent */
	public function teacher_create_consent_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_ids)){
            $response = array('status' => false, 'message' => 'Class IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($title)){
            $response = array('status' => false, 'message' => 'Title Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($time)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                   // print_r($fetch_student);exit;
            //       $image_link = '';
    			     //   if(!empty($attachment)){
    			     //       define('IMAGE_UPLOAD_DIR','assets/school_consents/');
        				// $img = str_replace('data:image/jpeg;base64','',$attachment);
        				// $img = str_replace(' ','+',$img);
        				// $user_data = base64_decode($img);
        				// $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				// $success = file_put_contents($user_file,$user_data); 
				
        				// if($success){
        				//     $image_link = $user_file;
        				// //     unlink($get_child_detaiils[0]['father_image']);
        			
        				//  }
    			     //   }
    			        
                
                        $data = array(
                            'school_id' => $school_id,
                            'teacher_id' => $teacher_id,
                            'class_ids' => $class_ids,
                            'student_ids' => $student_ids,
                            'group_ids' => $group_ids,
                            'date' => $date,
                            'time' => $time,
                            'created_date' => date('Y-m-d'),
                            'type' => $type,
                            'title' => $title,
                            'details' => $details,
                          //  'consent_image' => $image_link,
                            'status' => 1,
                            'created_on' => date('Y-m-d H:i:s'),
                            );
                            $insert = $this->user_model->common_insert('school_consent_details',$data);
                            if($insert){
                                
                               
    			       
    			        
    			        if(!empty($attachment_type)){
                    
                     if($attachment_type == "image"){
                            $images = explode(",",$attachment);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                    				 //   $image_link = $user_file;
                    				    $data1 = array(
            						'consent_id' => $insert,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				   
                                    			
                                    				 }
                            }
                            
                        }else if($attachment_type == "video"){
                              $videos = explode(",",$attachment);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				  //  $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $insert,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                            }
                        }else if($attachment_type == "audio"){
                             $audios = explode(",",$attachment);
                            foreach($audios as $vid){
                                if(!empty($vid)){
                                    define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:file/*;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp3';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $insert,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                                }
                            
                            }
                        }
                       
                }
                                
                            }
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher creating consent */
	
	/* teacher consent list details*/
	public function teacher_consent_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $consent_id = '';
            $date = '';
                $data = $this->user_model->get_teacher_consent_deatils($teacher_id,$date,$consent_id);
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'consent_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher consent list details*/
	
	/* teacher view single consent  details*/
	public function teacher_view_single_consent_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Consent ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $date = '';
                $data = $this->user_model->get_teacher_consent_deatils($teacher_id,$date,$consent_id);
                $atatchments = $this->user_model->common_fetch('school_consent_attachments',array('consent_id' => $consent_id));
               // echo $this->db->last_query();exit;
          //    echo print_r($data);exit;
                if(empty($data))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'consent_details' => $data, 'attachments' => $atatchments));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher view single consent  details*/
	
		/*teacher updating consent */
	public function teacher_updating_consent_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Consent IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_ids)){
            $response = array('status' => false, 'message' => 'Class IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($title)){
            $response = array('status' => false, 'message' => 'Title Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($time)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_consent_details',array('id' => $consent_id));
                   // print_r($fetch_student);exit;
                   $image_link = '';
                   
    			     //   if(!empty($attachment)){
    			     //       define('IMAGE_UPLOAD_DIR','assets/school_consents/');
        				// $img = str_replace('data:image/jpeg;base64','',$attachment);
        				// $img = str_replace(' ','+',$img);
        				// $user_data = base64_decode($img);
        				// $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				// $success = file_put_contents($user_file,$user_data); 
				
        				// if($success){
        				//     $image_link = $user_file;
        				//     if(!empty($get_clander_details[0]['attachment'])){
            // 				        unlink($get_clander_details[0]['attachment']);
            // 				    }
        				// //     unlink($get_child_detaiils[0]['father_image']);
        			
        				//  }
    			     //   }
    			        
                
                        $data = array(
                            'school_id' => $school_id,
                            'teacher_id' => $teacher_id,
                            'class_ids' => $class_ids,
                            'student_ids' => $student_ids,
                            'group_ids' => $group_ids,
                            'date' => $date,
                            'time' => $time,
                            'type' => $type,
                            'title' => $title,
                            'details' => $details,
                           // 'consent_image' => $image_link,
                            'status' => 1,
                            'updated_on' => date('Y-m-d H:i:s'),
                            );
                            $update = $this->user_model->common_update('school_consent_details',$data,array('id' => $consent_id));
                            if($update){
                                
                               
    			       
    			        
    			        if(!empty($attachment_type)){
                    
                     if($attachment_type == "image"){
                            $images = explode(",",$attachment);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                    				 //   $image_link = $user_file;
                    				    $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				   
                                    			
                                    				 }
                            }
                            
                        }else if($attachment_type == "video"){
                              $videos = explode(",",$attachment);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				  //  $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                            }
                        }else if($attachment_type == "audio"){
                             $audios = explode(",",$attachment);
                            foreach($audios as $vid){
                                if(!empty($vid)){
                                     define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:file/mp3;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp3';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                                }
                           
                            }
                        }
                       
                }
                                
                            }
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher updating consent */
	
	/*teacher delete consent */
	public function teacher_delete_consent_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Consent ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $get_clander_details = $this->user_model->common_fetch('school_consent_attachments',array('consent_id' => $consent_id));
                  
            				    if(!empty($get_clander_details)){
            				        foreach($get_clander_details as $cal){
            				            unlink($cal[0]['attachment']);
            				        }
            				        
            				    }
            		
                            $delete = $this->user_model->common_permanent_delete('school_consent_attachments',array('consent_id' => $consent_id));
            		
                            $delete = $this->user_model->common_permanent_delete('school_consent_details',array('id' => $consent_id));
                    
                         $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher delete consent */
	
		/*teacher delete consent attachment*/
	public function teacher_delete_consent_attachment_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Calender ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachment_id)){
            $response = array('status' => false, 'message' => 'Attachment ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_consent_attachments',array('id' => $attachment_id));
                  
            				    if(!empty($get_clander_details[0]['attachment'])){
            				        unlink($get_clander_details[0]['attachment']);
            				    }
            		
                            $delete = $this->user_model->common_permanent_delete('school_consent_attachments',array('id' => $attachment_id));
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher delete consent attachment*/
	
		/*teacher updating consent attachment */
	public function teacher_updating_consent_attachment_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($consent_id)){
            $response = array('status' => false, 'message' => 'Consent IDs Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_clander_details = $this->user_model->common_fetch('school_consent_details',array('id' => $consent_id));
                   // print_r($fetch_student);exit;
                       
    			        if(!empty($attachment_type)){
                    
                     if($attachment_type == "image"){
                            $images = explode(",",$attachment);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                    				 //   $image_link = $user_file;
                    				    $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				   
                                    			
                                    				 }
                            }
                            
                        }else if($attachment_type == "video"){
                              $videos = explode(",",$attachment);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				  //  $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                            }
                        }else if($attachment_type == "audio"){
                            define('IMAGE_UPLOAD_DIR','assets/school_consents/');
                				$img = str_replace('data:file/mp3;base64','',$attachment);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp3';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				     $data1 = array(
            						'consent_id' => $consent_id,
            						'attachment_type' => $attachment_type,
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            					 $this->user_model->common_insert('school_consent_attachments',$data1);
                				 }
                        }
                       
                }
                                
                            
                    
                
                
                 $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher updating consent attachment */
	
	
	/* teacher upload albums */
	public function teacher_upload_albums_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($title)){
            $response = array('status' => false, 'message' => 'Title Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($description)){
            $response = array('status' => false, 'message' => 'Description Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachments)){
            $response = array('status' => false, 'message' => 'Attachments Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => '$auth_token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                     $data = array(
                        'school_id' => $school_id, 
                        'teacher_id' => $teacher_id, 
                        'type' => $type,
                        'classes' => $classes,
                        'groups' => $groups,
                        'title' => $title,
                        'description' => $description,
                        'album_type' => $album_type,
                        'tag_album' => 'no',
                        'created_on' => date('Y-m-d H:i:s')
                        );
                    //     echo "<pre>";
                    // print_r($data);exit;
                    $insert = $this->user_model->common_insert('albums',$data);
                    if($insert){
                        if($album_type == "image"){
                            $images = explode(",",$attachments);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/albums/images/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $insert,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            }
                            
                        }else if($album_type == "video"){
                              $videos = explode(",",$attachments);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/albums/videos/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $insert,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            }
                        }
                        
                    }
                    
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
                 }
                 
        }
	}
	/* teacher upload albums */
	/* teacher album list */
	public function teacher_albums_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             $album_id = '';
                $get_albums = $this->user_model->get_teacher_albums_details($teacher_id,$school_id,$album_id);
                	$data = array();
               if(!empty($get_albums)){
                   $i = 0; 
                   foreach($get_albums as $album){
                      
                       $fetch_album_content1 = $this->user_model->common_fetch('album_content',array('album_id' => $album['id']));
                      $fetch_album_content = $this->user_model->fetch_album_content_for_teacher($album['id']);
                       $data[$i]['id'] = $album['id'];
                       $data[$i]['title'] = $album['title'];
                       $data[$i]['album_type'] = $album['album_type'];
                       $data[$i]['album_count'] = count($fetch_album_content1);
                       $data[$i]['album_content'] = $fetch_album_content;
                       
                       $i++;
                   }
                   
               }
               
                if(empty($get_albums))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'album_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher album list */
	/* teacher view single album details */
	public function teacher_view_single_album_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             
                $get_albums = $this->user_model->get_teacher_albums_details($teacher_id,$school_id,$album_id);
                	$data = array();
               if(!empty($get_albums)){
                   $i = 0; 
                   foreach($get_albums as $album){
                      
                       $fetch_album_content1 = $this->user_model->common_fetch('album_content',array('album_id' => $album['id']));
                   //   $fetch_album_content = $this->user_model->fetch_album_content_for_teacher($album['id']);
                   $data[$i] = $album;
                       $data[$i]['id'] = $album['id'];
                       $data[$i]['title'] = $album['title'];
                       $data[$i]['album_type'] = $album['album_type'];
                       $data[$i]['album_count'] = count($fetch_album_content1);
                       $data[$i]['album_content'] = $fetch_album_content1;
                       $data[$i]['class_names'] = $album['class_names'];
                       $data[$i]['group_names'] = $album['group_names'];
                       $data[$i]['classes'] = $album['classes'];
                       $data[$i]['groups'] = $album['groups'];
                       
                       $i++;
                   }
                   
               }
               
                if(empty($get_albums))
                {
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
    			           'album_details' => $data));
    				$this->response($response);
    			    
                }
            }
        }
	}
	/* teacher view single album details */
	
	/* teacher update upload albums */
	public function teacher_update_upload_albums_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($title)){
            $response = array('status' => false, 'message' => 'Title Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($description)){
            $response = array('status' => false, 'message' => 'Description Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => '$auth_token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                     $data = array(
                        'school_id' => $school_id, 
                        'teacher_id' => $teacher_id, 
                        'type' => $type,
                        'classes' => $classes,
                        'groups' => $groups,
                        'title' => $title,
                        'description' => $description,
                        'album_type' => $album_type,
                        'tag_album' => 'no',
                        'created_on' => date('Y-m-d H:i:s')
                        );
                    //     echo "<pre>";
                    // print_r($data);exit;
                    $update = $this->user_model->common_update('albums',$data,array('id' => $album_id));
                  //  if($update)
                    {
                        if($album_type == "image"){
                            $images = explode(",",$attachments);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/albums/images/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $album_id,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            }
                            
                        }else if($album_type == "video"){
                              $videos = explode(",",$attachments);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/albums/videos/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $album_id,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            }
                        }
                        
                    }
                    
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
                 }
                 
        }
	}
	/* teacher update upload albums */
	
	/* teacher delete album details */
	public function teacher_delete_album_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             
                $get_albums = $this->user_model->common_fetch('albums',array('id' => $album_id));
                	
               if(!empty($get_albums)){
                   
                   foreach($get_albums as $album){
                      
                       $fetch_album_content1 = $this->user_model->common_fetch('album_content',array('album_id' => $album_id));
                       foreach($fetch_album_content1 as $ac){
                           if(!empty($ac['file_name'])){
            				        unlink($ac['file_name']);
            				    }
                       }
                       
                       $this->user_model->common_permanent_delete('album_content',array('album_id' => $album_id));
                   
                   }
                   $this->user_model->common_permanent_delete('albums',array('id' => $album_id));
                   
               }
               
                
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Delete Successfully', 'response' => array());
    				$this->response($response);
    			    
        
            }
        }
	}
	/* teacher delete album details */
	
	/* teacher delete single file  album details */
	public function teacher_delete_single_file_album_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             
                $get_albums = $this->user_model->common_fetch('albums',array('id' => $album_id));
                	
               if(!empty($get_albums)){
                      
                       $fetch_album_content1 = $this->user_model->common_fetch('album_content',array('album_id' => $album_id, 'id' => $album_content_id));
                           if(!empty($fetch_album_content1[0]['file_name'])){
            				        unlink($fetch_album_content1[0]['file_name']);
            				    }
                       
                       
                       $this->user_model->common_permanent_delete('album_content',array('album_id' => $album_id, 'id' => $album_content_id));
                   
                   $get_albumseee = $this->user_model->common_fetch('album_content',array('album_id' => $album_id));
                   if(empty($get_albumseee)){
                        $this->user_model->common_permanent_delete('albums',array('id' => $album_id));
                   }
                  
                   
               }
            
               
                
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Delete Successfully', 'response' => array());
    				$this->response($response);
    			    
        
            }
        }
	}
	/* teacher delete single file album details */
	
	/* teacher update single file  album details */
	public function teacher_update_single_file_album_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_id)){
            $response = array('status' => false, 'message' => 'Album ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_type)){
            $response = array('status' => false, 'message' => 'Album Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($album_type)){
            $response = array('status' => false, 'message' => 'Album Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachments)){
            $response = array('status' => false, 'message' => 'Attachment Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             
              $data = array(
                        // 'school_id' => $school_id, 
                        // 'teacher_id' => $teacher_id, 
                        // 'type' => $type,
                        // 'classes' => $classes,
                        // 'groups' => $groups,
                        // 'title' => $title,
                        // 'description' => $description,
                        'album_type' => $album_type,
                      //  'tag_album' => 'no',
                        'updated_on' => date('Y-m-d H:i:s')
                        );
                    //     echo "<pre>";
                    // print_r($data);exit;
                    $update = $this->user_model->common_update('albums',$data,array('id' => $album_id));
                  //  if($update)
                    {
                        if($album_type == "image"){
                            //$images = explode(",",$attachments);
                            
                                define('IMAGE_UPLOAD_DIR','assets/albums/images/');
                				$img = str_replace('data:image/jpeg;base64','',$attachments);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $album_id,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            
                            
                        }else if($album_type == "video"){
                              //$videos = explode(",",$attachments);
                          
                                define('IMAGE_UPLOAD_DIR','assets/albums/videos/');
                				$img = str_replace('data:video/mp4;base64','',$attachments);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'album_id' => $album_id,
                    			    'file_name' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            
                        }
                        
                    }
                    
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
            
               
                
                    // $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Delete Successfully', 'response' => array());
    				$this->response($response);
    			    
        
            }
        }
	}
	/* teacher update single file album details */
	
	
	/*teacher view day care details */
	public function teacher_view_daycare_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            $get_activity = $this->user_model->common_fetch('activities',array('school_id' => $school_id,'delete_status' => 1));
            $get_meals = $this->user_model->common_fetch('daycare_meals',array('school_id' => $school_id,'delete_status' => 1));
            if(!empty($get_activity)){
                $activity = array();
                $i = 0;
                foreach($get_activity as $ac){
                    $activity[$i]['id'] = $ac['id'];
                    $activity[$i]['name'] = $ac['activity_name'];
                    $activity[$i]['image'] = $ac['activity_icon'];
                    $activity[$i]['type'] = 'activity';
                    $i++;
                }
            }
            if(!empty($get_meals)){
                $meal = array();
                $l = 0;
                foreach($get_meals as $ac){
                    $meal[$l]['id'] = $ac['id'];
                    $meal[$l]['name'] = $ac['meal_type'];
                    $meal[$l]['image'] = '';
                    $meal[$l]['type'] = 'meal';
                    $i++;
                }
            }
            
         $daycare =   array_merge($meal,$activity);
         
         $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('daycare' => $daycare));
    				$this->response($response);

                
            }
        }
	}
	/*teacher view day care details */
	/* teacher groups details */
	public function teacher_view_groups_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $get_groups = $this->user_model->get_teacher_admin_groups($teacher_id);
                if(empty($get_groups)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => array('groups' => ''));
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('groups' => $get_groups));
    				$this->response($response);
                }
            }
        }
	}
	/*teacher groups details */
	
	/*teacher group students */
	public function teacher_view_group_students_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_id)){
            $response = array('status' => false, 'message' => 'Group ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == ""){
                    $get_groups = $this->user_model->get_teacher_admin_group_students($group_id);
                }else if($type == "report"){
                 $get_groups =    $this->user_model->get_group_students_with_daycarerecords($group_id,$date);
                 //$fetch_daycarereports
                }
            
                
                if(empty($get_groups)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => array('groups' => ''));
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('groups' => $get_groups));
    				$this->response($response);
                }
            }
        }
	}
	/*teacher group students */
	/*teacher day care meal quantities */
	public function teacher_view_daycare_meal_quantities_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
            
                $get_groups = $this->user_model->common_fetch('daycare_meals_quantities',array('delete_status' => 1 , 'school_id' => $school_id));
                if(empty($get_groups)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => array('quantities' => ''));
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('quantities' => $get_groups));
    				$this->response($response);
                }
            }
        }
	}
	/*teacher day care meal quantities */
	
	/*teacher create day care report */
	public function teacher_create_daycare_report_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if($report_type == "meal"){
                    
                    $datam = array(
                         'report_type' => $report_type,
                         'school_id' => $school_id,
                         'staff_id' => $teacher_id,
                         'group_id' => $group_id,
                         'date' => $date,
                         'start_time' => $start_time,
                         'meal_name' => $meal_name,
                         'quantity' => $quantity,
                         'notify_parent' => $notify_parent,
                         'edit' => $edit,
                         'created_on' => date('Y-m-d')
                         ); 
                         $insert = $this->user_model->common_insert('daycare_reports',$datam);
                         
                         
                    $students  = explode(',',$student_ids);
                    foreach($students as $stu){
                     $datammmm = array(
                        'daycare_report_id' => $insert,
                         'student_id' => $stu,
                         'created_on' => date('Y-m-d')
                         ); 
                         $this->user_model->common_insert('daycare_reports_studnets',$datammmm);
                    }
                }else if($report_type == "activity"){
                    
                    $dataa = array(
                         'report_type' => $report_type,
                         'school_id' => $school_id,
                         'staff_id' => $teacher_id,
                         'group_id' => $group_id,
                         'date' => $date,
                         'start_time' => $start_time,
                         'end_time' => $end_time,
                         'remarks' => $remarks,
                         'notify_parent' => $notify_parent,
                         'edit' => $edit,
                         'created_on' => date('Y-m-d')
                         ); 
                        $insert =  $this->user_model->common_insert('daycare_reports',$dataa);
                         
                         
                     $students  = explode(',',$student_ids);
                    foreach($students as $stu){
                     $dataaaaa = array(
                        'daycare_report_id' => $insert,
                         'student_id' => $stu,
                         'created_on' => date('Y-m-d')
                         ); 
                          $this->user_model->common_insert('daycare_reports_studnets',$dataaaaa);
                    }
                }
                
                 /*image uploads*/
               
                if(!empty($attachment)){
                            $images = explode(",",$attachment);
                           
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/students_daycare/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                    				 //   $image_link = $user_file;
                    				    $data1 = array(
            						'daycare_report_id' => $insert,
            						'attachment_type' => 'image',
            						'attachment' =>$user_file,
            						'created_on' => date('Y-m-d H:i:s')
            						);
            				       	 $this->user_model->common_insert('school_daycare_reports_attachments',$data1);
                                    }
                            }
                            
                        }
                        
            /* image uploads*/
            
            
                
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => (object)array());
    				$this->response($response);
                
            }
        }
	}
	/*teacher create day care report */
	
	/* teacher view student daycare report */
	public function teacher_view_student_daycare_report_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Class IDs Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_student_daycare = $this->user_model->get_student_daycare_reports_for_teacher($student_id,$date);
                $get_attachments = '';
                if(!empty($get_student_daycare)){
                    foreach($get_student_daycare as $daycare){
                        $get_attachments = $this->user_model->common_fetch('school_daycare_reports_attachments',array('daycare_report_id' => $daycare['id']));
                    }
                }
                if(empty($get_student_daycare)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                    array('student_daycare_reports' => $get_student_daycare, 'attachments' => $get_attachments));
    				$this->response($response);
                }
            }
        }
	}
	/* teacher view student daycare report */
	/* teacher delete student daycare report */
	public function teacher_delete_student_daycare_report_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($daycare_report_id)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
           
                     $this->user_model->common_permanent_delete('daycare_reports_studnets',
                        array('daycare_report_id' => $daycare_report_id, 'student_id' => $student_id));
                
            
                    $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' =>'' );
    				$this->response($response);
                
            }
        }
	}
	/* teacher delete student daycare report */
	
	/* teacher view daycare activities */
	public function teacher_view_daycare_activities_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_student_daycare = $this->user_model->common_fetch('activities',array('school_id' => $school_id));
               
                if(empty($get_student_daycare)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                    array('activities' => $get_student_daycare));
    				$this->response($response);
                }
            }
        }
	}
	/* teacher view  daycare activities */
	
	/* teacher view daycare activities icons*/
	public function teacher_view_daycare_activities_icons_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_student_daycare = $this->user_model->common_fetch('activity_icons',array('school_id' => $school_id));
               
                if(empty($get_student_daycare)){
                    $response = array('status' => false, 'message' => 'No Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                    array('activities' => $get_student_daycare));
    				$this->response($response);
                }
            }
        }
	}
	/* teacher view  daycare activities icons */
	
	/* teacher update daycare activity icon */
	public function teacher_update_daycare_activity_icon_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($activity_id)){
            $response = array('status' => false, 'message' => 'Activity ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($activity_icon_id)){
            $response = array('status' => false, 'message' => 'Activity Icon Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $get_student_daycare = $this->user_model->common_fetch('activity_icons',array('school_id' => $school_id,'id' => $activity_icon_id));
                $data = array(
                    'activity_icon' => $get_student_daycare[0]['activity_icon'],
                    'updated_on' => date('Y-m-d H:i:s')
                    );
                    $this->user_model->common_update('activities',$data,array('id' => $activity_id));
                
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => '');
    				$this->response($response);
                
            }
        }
	}
	/* teacher update  daycare activity icon */
	
	/* teacher send daycare report to mail */
	public function teacher_send_daycare_report_mail_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($from_date)){
            $response = array('status' => false, 'message' => 'From Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($to_date)){
            $response = array('status' => false, 'message' => 'To Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($email)){
            $response = array('status' => false, 'message' => 'Email Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			  
    	
    			 //   $this->load->config('email');
        // $this->load->library('email');
        //     $from = 'sagarnalluri22@gmail.com';
        //     $to = 'sagarnalluri22@gmail.com';
        //     $subject = 'test';
        //     $message = 'test';
        //      $this->email->set_newline("\r\n");
        // $this->email->from($from);
        // $this->email->to($to);
        // $this->email->subject($subject);
        // $this->email->message($message);

        // if ($this->email->send()) {
        //     echo 'Your Email has successfully been sent.';
        // } else {
        //     show_error($this->email->print_debugger());
        // }
             
        //     echo $this->email->print_debugger();
        //     exit;
            $response = array('status' => true, 'message' => 'Report Shared Successfully', 'response' => (object)array());
                   $this->response($response);
    				
    			
            }
			
		}
	}
	
	/* teacher send daycare report to mail */
	
	
	
	/*teacher view student attendance */
	public function teacher_view_studnet_attendance_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             $get_attendance = $this->user_model->get_student_attendance_class_wise($school_id,$class_id,$date);
           //  echo $this->db->last_query();exit;
                $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                    array('attendance' => $get_attendance));
    				$this->response($response);
            }
        }
	}
	/*teacher view student attendance */
	
	/*teacher update student attendance */
	public function teacher_updating_studnet_attendance_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch_attendance = $this->user_model->common_fetch('student_attendance_day_wise',
                array('class_id' => $class_id,'date' => $date,'school_id' => $school_id));
                if(empty($fetch_attendance)){
                    $data = array(
                        'school_id' => $school_id,
                        'class_id' => $class_id,
                        'date' => $date,
                        'total_present' => $total_present,
                        'total_absent' => $total_absent,
                        'teacher_id' => $teacher_id,
                        'send_notification' => $send_notification,
                        'created_on' => date('Y-m-d H:i:s')
                        );
                       $insert =  $this->user_model->common_insert('student_attendance_day_wise',$data);
                       if($insert){
                           if(!empty($present_students)){
                               $present = explode(",",$present_students);
                                foreach($present as $pre){
                                    $datap = array(
                                        'attendance_id' => $insert,
                                        'student_id' => $pre,
                                        'created_on' => date('Y-m-d H:i:s')
                                        );
                                    $this->user_model->common_insert('present_students',$datap);
                                }
                           }
                            
                            if(!empty($absent_students)){
                            $absent = explode(",",$absent_students);
                                foreach($absent as $abs){
                                    $dataa = array(
                                        'attendance_id' => $insert,
                                        'student_id' => $abs,
                                        'created_on' => date('Y-m-d H:i:s')
                                        );
                                    $this->user_model->common_insert('absent_students',$dataa);
                                }
                            }
                       }
                        
                }else{
                    $data = array(
                        //'school_id' => $school_id,
                       // 'class_id' => $class_id,
                       // 'date' => $date,
                        'total_present' => $total_present,
                        'total_absent' => $total_absent,
                        //'teacher_id' => $teacher_id,
                        'send_notification' => $send_notification,
                        'updated_on' => date('Y-m-d H:i:s')
                        );
                       $update =  $this->user_model->common_update('student_attendance_day_wise',$data,
                        array('id' => $fetch_attendance[0]['id']));
                        
                        if($fetch_attendance[0]['id']){
                            $this->user_model->common_permanent_delete('present_students',array('attendance_id' => $fetch_attendance[0]['id']));
                            $this->user_model->common_permanent_delete('absent_students',array('attendance_id' => $fetch_attendance[0]['id']));
                            if(!empty($present_students)){
                                $present = explode(",",$present_students);
                                foreach($present as $pre){
                                    $datap = array(
                                        'attendance_id' => $fetch_attendance[0]['id'],
                                        'student_id' => $pre,
                                        'created_on' => date('Y-m-d H:i:s')
                                        );
                                    $this->user_model->common_insert('present_students',$datap);
                                }
                            }
                            if(!empty($absent_students)){
                            $absent = explode(",",$absent_students);
                                foreach($absent as $abs){
                                    $dataa = array(
                                        'attendance_id' => $fetch_attendance[0]['id'],
                                        'student_id' => $abs,
                                        'created_on' => date('Y-m-d H:i:s')
                                        );
                                    $this->user_model->common_insert('absent_students',$dataa);
                                }
                            }
                       }
                       
                }
                
                $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => (object)array());
    				$this->response($response);
            }
        }
	}
	/*teacher update student attendance */
	
	/* teacher new mesage create */
	
	public function teacher_create_new_message_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Student IDs Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_ids)){
            $response = array('status' => false, 'message' => 'Class IDs Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject)){
            $response = array('status' => false, 'message' => 'Subject IDs Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($message)){
            $response = array('status' => false, 'message' => 'Message Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $files = '';
                if(!empty($attachment_type)){
                    
                     if($attachment_type == "image"){
                            $images = explode(",",$attachments);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/attachments/staff/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    
                				    if(empty($files)){
                    	             $files = $image_link;
                    	         }else if(!empty($image_link)){
                    	                $files = $files.','.$image_link;
                    	            }
                                    				    
                                    				//     $dataimage = array(
                                        // 			    'album_id' => $album_id,
                                        // 			    'file_name' => $image_link,
                                        // 			    'created_on' => date('Y-m-d H:i:s')
                                        // 			    );
                                        // 			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                                    				 }
                            }
                            
                        }else if($attachment_type == "video"){
                              $videos = explode(",",$attachments);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/attachments/staff/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    if(empty($files)){
	             $files = $image_link;
	         }else if(!empty($image_link)){
	                $files = $files.','.$image_link;
	            }
                				//     $dataimage = array(
                    // 			    'album_id' => $album_id,
                    // 			    'file_name' => $image_link,
                    // 			    'created_on' => date('Y-m-d H:i:s')
                    // 			    );
                    // 			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                            }
                        }else if($attachment_type == "audio"){
                            define('IMAGE_UPLOAD_DIR','assets/attachments/staff/');
                				$img = str_replace('data:file/mp3;base64','',$attachments);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp3';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    if(empty($files)){
	             $files = $image_link;
	         }else if(!empty($image_link)){
	                $files = $files.','.$image_link;
	            }
                				//     $dataimage = array(
                    // 			    'album_id' => $album_id,
                    // 			    'file_name' => $image_link,
                    // 			    'created_on' => date('Y-m-d H:i:s')
                    // 			    );
                    // 			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                        }else if($attachment_type == "document"){
                            define('IMAGE_UPLOAD_DIR','assets/attachments/staff/');
                				$img = str_replace('data:file/pdf;base64','',$attachments);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.pdf';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    if(empty($files)){
	             $files = $image_link;
	         }else if(!empty($image_link)){
	                $files = $files.','.$image_link;
	            }
                				//     $dataimage = array(
                    // 			    'album_id' => $album_id,
                    // 			    'file_name' => $image_link,
                    // 			    'created_on' => date('Y-m-d H:i:s')
                    // 			    );
                    // 			$insertimage = $this->user_model->common_insert('album_content',$dataimage);
                				 }
                        }
                }
                
                $data = array(
                    'school_id' => $school_id,
                    'teacher_id' => $teacher_id,
                    'date' => date('Y-m-d'),
                    'to_class' => $class_ids,
                    'to_student' => $student_ids,
                    'to_staff' => $staff_ids,
                    'to_group' => $group_ids,
                    'sent_from' => 'teacher',
                    'message_type' => $message_type,
                    'schedule_date' => $schedule_date,
                    'schedule_time' => $schedule_time,
                    'disable_replies' => $disable_replies,
                    'subject' => $subject,
                    'message' => $message,
                    'attachment_type' => $attachment_type,
                    'attachments' => $files,
                    'signature' => $signature,
                    'message_status' => 'sent',
                    'created_on' => date('Y-m-d H:i:s')
                
                    );
                    $insert = $this->user_model->common_insert('staff_messages',$data);
                     $response = array('status' => true, 'message' => 'Message Sent Successfully', 'response' => (object)array());
    				$this->response($response);
                    
                
            }
        }
	}
		/* teacher new mesage create */
		
	/*parent sent messages view*/

	public function teacher_view_sent_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$sent_message_id = "";
    			$fetch = $this->user_model->get_staff_sent_messages($teacher_id,$school_id,$message_type,$sent_message_id);
    			    //echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array('sent_messages' => [] ));
    				$this->response($response);
    			}else{
    			    
    			   
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('sent_messages' => $fetch));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent sent messages view*/
	
	/*parent view single sent message*/

	public function teacher_view_single_sent_message_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($sent_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$message_type = '';
    			$fetch = $this->user_model->get_staff_sent_messages($teacher_id,$school_id,$message_type,$sent_message_id);
    			$get_replys = $this->user_model->get_staff_sent_replys($sent_message_id);
    			    //echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('sent_messages' => $fetch,
    				'replys' => $get_replys));
    				$this->response($response);
    			}
            }
			
		}
	}
	/*parent view single sent message*/
	
	/*parent delete single sent message*/

	public function teacher_delete_single_sent_message_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($sent_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			$this->user_model->common_permanent_delete('replys_for_school_staff_messages',array('message_id' => $sent_message_id));
    			$get_message = $this->user_model->common_fetch('staff_messages',array('id' => $sent_message_id));
    			if(!empty($get_message) && !empty($get_message[0]['attachments'])){
        			 $atatchments =    explode(",",$get_message[0]['attachments']);
        			 foreach($atatchments as $att){
        			     unlink($att);
        			 }
    			}
    			$this->user_model->common_permanent_delete('staff_messages',array('id' => $sent_message_id));
    			    //echo $this->db->last_query();exit;
    				$response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => '');
    				$this->response($response);
    			
            }
			
		}
	}
	/*parent delete single sent message*/
	
	
	
	
	/* parent inbox messages */
	public function teacher_inbox_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if($messages_type == "parent"){
                 //   echo "hi";
                    $fetch = $this->user_model->get_staff_inbox_messages_of_parent($teacher_id,$school_id);
                    //echo $this->db->last_query();exit;
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "parent";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "parent";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "parent";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "parent";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
    			 
    			 	if(empty($data)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data));
    				$this->response($response);
    			}
    			
    			
                }else if($messages_type == "staff"){
                    $fetch = $this->user_model->get_staff_inbox_messages_of_staff($teacher_id,$school_id);
                    /*system messages*/
                      $sent_message_id = "";
    			
               //echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "teacher";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "teacher";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "teacher";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = $fff['name'];
        			        $data[$i]['inbox_message_from'] = "teacher";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
    			 
    			 	if(empty($data)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data));
    				$this->response($response);
    			}
    			
    			
                }else if($messages_type == "system"){
                    $fetch = $this->user_model->get_staff_inbox_messages_of_admin($teacher_id,$school_id);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = "Little Pebbels";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = "Little Pebbels";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = "Little Pebbels";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data[$i]['message_id'] = $fff['id'];
        			        $data[$i]['name'] = "Little Pebbels";
        			        $data[$i]['inbox_message_from'] = "school_admin";
        			        $data[$i]['subject'] = $fff['subject'];
        			        $data[$i]['message'] = $fff['message'];
        			        $data[$i]['date'] = $fff['date'];
        			        $data[$i]['read_message'] = $fff['read_message'];
        			        $data[$i]['starred_message'] = $fff['starred_message'];
        			        $data[$i]['archived_message'] = $fff['archived_message'];
        			        $data[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
    			 
    			 	   // echo $this->db->last_query();exit;
    			if(empty($data)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data));
    				$this->response($response);
    			}
    			
    			
                } else if($messages_type == "all")
                {
                    
                 /*------------------------------------------------------------------------*/   
                    /*system messages start*/
                     $fetch = $this->user_model->get_staff_inbox_messages_of_admin($teacher_id,$school_id);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $data_sysytem[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $data_sysytem[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $data_sysytem[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $data_sysytem[$i]['image'] = '';
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
                    /*system messages end */
            /*----------------------------------------------------------------------------------------*/
            
            /* staff messages start */
                    
                    $fetch_staff = $this->user_model->get_staff_inbox_messages_of_staff($teacher_id,$school_id);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $data_staff[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $data_staff[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $data_staff[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $data_staff[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
              /* staff messages start */  
              /*-----------------------------------------------------------------------------------*/
              
              /* parent messages start */
                    $fetch_parent = $this->user_model->get_staff_inbox_messages_of_parent($teacher_id,$school_id);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $data_parent[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $data_parent[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $data_parent[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $data_parent[$i]['image'] = $fff['image'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
              /* parent messages start */
              
              $all = array_merge($data_sysytem,$data_staff, $data_parent);
              
              
                usort($all, function ($a, $b) {
                    return strtotime($b['date']) - strtotime($a['date']); // Sort in descending order
                });
                
               // print_r($array);
               
               	if(empty($all)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $all));
    				$this->response($response);
    			}
    			
                              
              
                }//all messages end
                
                
                  
    		
            }
			
		}
	}
	
	/* parent inbox messages */
	/*parent view inbox message*/
	public function teacher_view_single_inbox_message_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_from)){
            $response = array('status' => false, 'message' => 'Inbox message from Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                if($inbox_message_from == "school_admin"){
                    $fetch = $this->user_model->get_staff_inbox_message_details_of_admin($teacher_id,$inbox_message_id);
                   // echo $this->db->last_query();exit;
                }else if($inbox_message_from == "teacher"){
                    $fetch = $this->user_model->get_staff_inbox_message_details_of_staff($teacher_id,$inbox_message_id);
                    
                }else if($inbox_message_from == "parent"){
                    $fetch = $this->user_model->get_staff_inbox_message_details_of_parent($teacher_id,$inbox_message_id);
                   // echo $this->db->last_query();exit;
                }
                
                if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => (object)array());
    				$this->response($response);
    			}else{
    			    $arr = [];
    			    if(!empty($fetch[0]['attachments'])){
    			        $new = $fetch[0]['attachments'];
    			        $arr =  explode(",",$new);
    			        
    			     //  print_r($arr);exit;
    			    }else{
    			        $arr = [];
    			    }
    			    $fetch[0]['images'] =  $arr[0];
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
    				array('inbox_message' => $fetch));
    				$this->response($response);
    			}
                
            }
        }
	}
	/*parent view inbox message*/
	
	/*parent read inbox message*/
	public function teacher_inbox_message_read_starred_archived_post()
	{
	     $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_id)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_from)){
            $response = array('status' => false, 'message' => 'Inbox message from Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_message_status)){
            $response = array('status' => false, 'message' => 'Inbox message status Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                    $check = $this->user_model->common_fetch('staff_read_messages',array('staff_id' => $teacher_id,
                    'message_type' => $inbox_message_from,'message_id' => $inbox_message_id));
                    if(empty($check)){
                            if($inbox_message_status == "read"){
                                $data = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'read_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "starred"){
                                $data = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "archived"){
                                $data = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "yes",
            			            'created_on' =>date('Y-m-d H:i:s')
            			            );
                            }
                        $insert = $this->user_model->common_insert('staff_read_messages',$data);
                        
                    }else{
                        if($inbox_message_status == "read"){
                                $data1 = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'read_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "starred"){
                                $data1 = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "archived"){
                                $data1 = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "unarchived"){
                                $data1 = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'archived_message' => "",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }else if($inbox_message_status == "unstarred"){
                                $data1 = array(
            			            'staff_id' => $teacher_id,
            			            'message_type' => $inbox_message_from,
            			            'message_id' => $inbox_message_id,
            			            'starred_message' => "",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
                            }
                           $update = $this->user_model->common_update('staff_read_messages',$data1,array('staff_id' => $teacher_id,
                    'message_type' => $inbox_message_from,'message_id' => $inbox_message_id)); 
                        
                    }
                    
                    
                    $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
        				$this->response($response);
                  
    			           // print_r($data);
    			            //exit;
    			 }
    			    
    			    
    			    
    				
                
            }
        
	}
	/*parent read inbox message*/
	
	/*parent mark as all read messages*/
	public function teacher_mark_as_all_read_messages_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($inbox_messages)){
            $response = array('status' => false, 'message' => 'Message ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{ 
                 
                    if(!empty($inbox_messages)){
                        foreach($inbox_messages as $inbox){
                            $check = $this->user_model->common_fetch('staff_read_messages',array('staff_id' => $teacher_id,
                    'message_type' => $inbox['from'],'message_id' => $inbox['id']));
                    
                            if(!empty($check)){
                                $data = array(
            			          //  'student_id' => $child_id,
            			          //  'message_type' => $inbox['from'],
            			         //   'message_id' => $inbox['id'],
            			            'read_message' => "yes",
            			            'updated_on' =>date('Y-m-d H:i:s')
            			            );
            			            $update = $this->user_model->common_update('staff_read_messages',$data,array('staff_id' => $teacher_id,
                                    'message_type' => $inbox['from'],'message_id' => $inbox['id']));
                            }else{
                                $data1 = array(
            			              'staff_id' => $teacher_id,
            			              'message_type' => $inbox['from'],
            			              'message_id' => $inbox['id'],
            			              'read_message' => "yes",
            			              'created_on' =>date('Y-m-d H:i:s')
            			            );
            			            $insert = $this->user_model->common_insert('staff_read_messages',$data1);
                            }
                        }
                            
                        
                        
                    }
                    
                    
                    
                    $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
        				$this->response($response);
                  
    			           // print_r($data);
    			            //exit;
    			 }
    			    
    			    
    			    
    				
                
            }
        
	}
	/*parent mark as all read messages*/
	
	/* teacher search inbox messages */
	public function teacher_search_inbox_messages_post()
	{
		$user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($search_subject)){
            $response = array('status' => false, 'message' => 'Search BY subject Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                    
    		{
                    
                 /*------------------------------------------------------------------------*/   
                    /*system messages start*/
                     $fetch = $this->user_model->get_staff_inbox_search_messages_of_admin($teacher_id,$school_id,$search_subject);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_sysytem = array();
        			if(!empty($fetch)){
        			    $i=0;
        			    foreach($fetch as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_sysytem[$i]['message_id'] = $fff['id'];
        			        $data_sysytem[$i]['name'] = "Little Pebbels";
        			        $data_sysytem[$i]['inbox_message_from'] = "school_admin";
        			        $data_sysytem[$i]['subject'] = $fff['subject'];
        			        $data_sysytem[$i]['message'] = $fff['message'];
        			        $data_sysytem[$i]['date'] = $fff['date'];
        			        $data_sysytem[$i]['read_message'] = $fff['read_message'];
        			        $data_sysytem[$i]['starred_message'] = $fff['starred_message'];
        			        $data_sysytem[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
                    /*system messages end */
            /*----------------------------------------------------------------------------------------*/
            
            /* staff messages start */
                    
                    $fetch_staff = $this->user_model->get_staff_inbox_search_messages_of_staff($teacher_id,$school_id,$search_subject);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_staff = array();
        			if(!empty($fetch_staff)){
        			    $i=0;
        			    foreach($fetch_staff as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_staff[$i]['message_id'] = $fff['id'];
        			        $data_staff[$i]['name'] = $fff['name'];
        			        $data_staff[$i]['inbox_message_from'] = "teacher";
        			        $data_staff[$i]['subject'] = $fff['subject'];
        			        $data_staff[$i]['message'] = $fff['message'];
        			        $data_staff[$i]['date'] = $fff['date'];
        			        $data_staff[$i]['read_message'] = $fff['read_message'];
        			        $data_staff[$i]['starred_message'] = $fff['starred_message'];
        			        $data_staff[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
              /* staff messages start */  
              /*-----------------------------------------------------------------------------------*/
              
              /* parent messages start */
                    $fetch_parent = $this->user_model->get_staff_inbox_search_messages_of_parent($teacher_id,$school_id,$search_subject);
                    /*system messages*/
                      $sent_message_id = "";
    			
            //    echo $this->db->last_query();exit;
    			if(empty($inbox_message_type))
    			{
    			   /*all messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['archived_message'] == ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*all messages */ 
    			}else if($inbox_message_type == "archived")
    			{
    			        			   /*archived messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['archived_message'] != ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*archived messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "starred")
    			{
    			        			   /*starred messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['starred_message'] != ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*starred messages */ 
    			    
    			 }
    			 else if($inbox_message_type == "read_message")
    			{
    			        			   /*read messages */ 
        			$data_parent = array();
        			if(!empty($fetch_parent)){
        			    $i=0;
        			    foreach($fetch_parent as $fff){
        			        if($fff['read_message'] == ""){
        			            
        			       
        			        $data_parent[$i]['message_id'] = $fff['id'];
        			        $data_parent[$i]['name'] = $fff['name'];
        			        $data_parent[$i]['inbox_message_from'] = "parent";
        			        $data_parent[$i]['subject'] = $fff['subject'];
        			        $data_parent[$i]['message'] = $fff['message'];
        			        $data_parent[$i]['date'] = $fff['date'];
        			        $data_parent[$i]['read_message'] = $fff['read_message'];
        			        $data_parent[$i]['starred_message'] = $fff['starred_message'];
        			        $data_parent[$i]['archived_message'] = $fff['archived_message'];
        			        $i++;
        			        }
        			    }
        			}
        			 /*read messages */ 
    			    
    			 }
    			 
    			 /*system messages*/
              /* parent messages start */
              
              $all = array_merge($data_sysytem,$data_staff, $data_parent);
              
              
                usort($all, function ($a, $b) {
                    return strtotime($b['date']) - strtotime($a['date']); // Sort in descending order
                });
                
               // print_r($array);
               
               	if(empty($all)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $all));
    				$this->response($response);
    			}
    			
                              
              
                }//all messages end
                
                
                
    			   // echo $this->db->last_query();exit;
    			if(empty($fetch)){
    				$response = array('status' => false, 'message' => 'Empty Details', 'response' => array());
    				$this->response($response);
    			}else{
    			    
    			    $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    				$response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('inbox_messages' => $data,
    				'parent' =>$check));
    				$this->response($response);
    			}
            }
			
		}
	}
	
	/* teacher search inbox messages */
	
	/* teacher reply to message to admin */
	public function teacher_reply_to_inbox_message_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($message_type)){
            $response = array('status' => false, 'message' => 'Meesage Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                 $image_link = '';
    			        if(!empty($attachment)){
    			            define('IMAGE_UPLOAD_DIR','assets/reply_attachments/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
    			        
                  if($message_type == "school_admin"){
                     
                      $data_message = array(
                          'message_id' => $message_id,
                          'sender_type' => 'teacher',
                          'sender_id' => $teacher_id,
                          'reply_message' => $reply_message,
                          'attachment' => $image_link,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('replys_for_school_admin_messages',$data_message);
                   //   echo $this->db->last_query();exit;
                  }else if($message_type == "teacher"){
                      
                      $data_message = array(
                          'message_id' => $message_id,
                          'sender_type' => 'teacher',
                          'sender_id' => $teacher_id,
                          'reply_message' => $reply_message,
                          'attachment' => $image_link,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('replys_for_school_staff_messages',$data_message);
                      
                  }else if($message_type == "parent"){
                      $data_message = array(
                          'message_id' => $message_id,
                          'sender_type' => 'teacher',
                          'sender_id' => $teacher_id,
                          'reply_message' => $reply_message,
                          'attachment' => $image_link,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('replys_for_school_parent_messages',$data_message);
                  }
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                
            }
        }
	}
	/* teacher reply to message to admin */
	
	/*teacher inbox messages replys */
	public function teacher_inbox_messages_replys_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // if($message_type == "school_admin"){
                    $get_replys = $this->user_model->get_parent_inbox_replys($message_id);
                    if(empty($get_replys)){
                        $response = array('status' => true, 'message' => 'Empty Data', 'response' => array('replys' => array()));
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('replys' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/*teacher inbox messages replys */
	
	/*teacher sent messages replys */
	public function teacher_sent_messages_replys_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($message_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // if($message_type == "school_admin"){
                    $get_replys = $this->user_model->get_staff_sent_replys($message_id);
                    if(empty($get_replys)){
                        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array('replys' => array()));
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('replys' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/*teacher sent messages replys */
	
	/*teacher signature update */
	public function teacher_signature_update_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($signature)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $data = array(
                    'employee_signature' => $signature,
                    'updated_on' => date('Y-m-d H:i:s')
                    );
                    $update = $this->user_model->common_update('staff',array('id' => $teacher_id));
    			  
    	
    			 //   $this->load->config('email');
        // $this->load->library('email');
        //     $from = 'sagarnalluri22@gmail.com';
        //     $to = 'sagarnalluri22@gmail.com';
        //     $subject = 'test';
        //     $message = 'test';
        //      $this->email->set_newline("\r\n");
        // $this->email->from($from);
        // $this->email->to($to);
        // $this->email->subject($subject);
        // $this->email->message($message);

        // if ($this->email->send()) {
        //     echo 'Your Email has successfully been sent.';
        // } else {
        //     show_error($this->email->print_debugger());
        // }
             
        //     echo $this->email->print_debugger();
        //     exit;
        $teacher = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            $response = array('status' => true, 'message' => 'Signature updated successfully', 'response' => $teacher);
                   $this->response($response);
    				
    			
            }
			
		}
	}
	/*teacher signature update */
	
	
	
	/* directory module start */
	
	/*staff list start*/
	public function teacher_staff_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_type)){
            $response = array('status' => false, 'message' => 'Staff Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == "search" && !empty($search_key)){
                    $get_replys = $this->user_model->get_search_staff_details($school_id,$staff_type,$search_key);
                }else if($type == "" && empty($search_key)){
                   $staff_id = '';
                    $get_replys = $this->user_model->get_all_staff_details($school_id,$staff_type,$staff_id); 
                }else{
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }
               // if($message_type == "school_admin"){
               
                    if(empty($get_replys)){
                        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('staff' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/* staff list  end */
	
		/*single staff details start*/
	public function teacher_view_single_staff_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_type)){
            $response = array('status' => false, 'message' => 'Staff Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Staff ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               // if($message_type == "school_admin"){
                    $get_replys = $this->user_model->get_all_staff_details($school_id,$staff_type,$staff_id);
                    if(empty($get_replys)){
                        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('staff' => $get_replys));
    				$this->response($response);
                    }
                // }else if($message_type == "teacher"){
                    
                // }
                
            }
            
            
        }
	}
	/*single staff details end*/
	
	/*generate employee id start*/
	public function teacher_generate_employee_id_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_type)){
            $response = array('status' => false, 'message' => 'Staff Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Staff ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
              
                     $get_all_emp = $this->user_model->common_fetch('staff',array('school_id' => $school_id));
	    $employee_id = 'LPIS-'.count($get_all_emp)+1;
                    
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('employee_id' => $employee_id));
    				$this->response($response);
                  
                
                
            }
            
            
        }
	}
	/*generate employee id end*/
	
	/* teacher update staff details */
	public function teacher_update_staff_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_name)){
            $response = array('status' => false, 'message' => 'Employee Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_email)){
            $response = array('status' => false, 'message' => 'Employee Email Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_id)){
            $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_gender)){
            $response = array('status' => false, 'message' => 'Employee Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_mobile)){
            $response = array('status' => false, 'message' => 'Employee Mobile Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('staff',array('id' => $staff_id));
                if(!empty($fetch)){
                    $image_link = '';
    			        if(!empty($employee_image)){
    			            if(!empty($fetch[0]['employee_image'])){
    			                unlink($fetch[0]['employee_image']);
    			            }
    			            define('IMAGE_UPLOAD_DIR','assets/images/staff/');
        				$img = str_replace('data:image/jpeg;base64','',$employee_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'employee_id' => $employee_id,
                          'employee_name' => $employee_name,
                          'employee_email' => $employee_email,
                          'employee_dob' => $employee_dob,
                          'employee_gender' => $employee_gender,
                          'employee_mobile' => $employee_mobile,
                          'employee_image' => $image_link,
                          'employee_designation' => $employee_designation,
                          'employee_department' => $employee_department,
                          'employee_use_designation' => $employee_use_designation,
                          'employee_class' => $employee_class,
                          'date_of_joining' => $date_of_joining,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('staff',$data_message,array('id' => $staff_id));
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher update staff details*/
	
	/*tecaher view staff access rights details start */
	public function teacher_view_staff_access_rights_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->get_staff_rights_details($staff_id);
                //echo $this->db->last_query();exit;
                if(empty($fetch)){
                  $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('staff_access_rights' => $fetch));
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/*tecaher view staff access rights details start */
	
		/* teacher update staff access rights details */
	public function teacher_update_staff_access_rights_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($access_right_ids)){
            $response = array('status' => false, 'message' => 'Employee Mobile Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_permanent_delete('staff_all_rights',array('staff_id' => $staff_id));
             $rights =    explode(",",$access_right_ids);
             foreach($rights as $id){
                 $data_message = array(
                          'staff_id' => $staff_id,
                          'right_id' => $id,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_insert('staff_all_rights',$data_message);
             }
                
                   //   echo $this->db->last_query();exit;
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
                        
                
            }
        }
	}
	/* teacher update staff access rights details*/
	
	/* teacher view all access rights list */
	public function teacher_view_all_access_rights_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Meesage ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($access_right_ids)){
            $response = array('status' => false, 'message' => 'Employee Mobile Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_employee_all_rights_list',array('delete_status' => 1));
                   //   echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'access_rights' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view all access rights list */
	
	/* teacher create staff details */
	public function teacher_create_staff_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($employee_name)){
            $response = array('status' => false, 'message' => 'Employee Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_email)){
            $response = array('status' => false, 'message' => 'Employee Email Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_id)){
            $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_gender)){
            $response = array('status' => false, 'message' => 'Employee Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($employee_mobile)){
            $response = array('status' => false, 'message' => 'Employee Mobile Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('staff',array('employee_mobile' => $employee_mobile));
                if(empty($fetch)){
                    $image_link = '';
    			        if(!empty($employee_image)){
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/staff/');
        				$img = str_replace('data:image/jpeg;base64','',$employee_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'employee_id' => $employee_id,
                          'employee_name' => $employee_name,
                          'employee_email' => $employee_email,
                          'employee_dob' => $employee_dob,
                          'employee_gender' => $employee_gender,
                          'employee_mobile' => $employee_mobile,
                          'employee_image' => $image_link,
                          'employee_designation' => $employee_designation,
                          'employee_department' => $employee_department,
                          'employee_use_designation' => $employee_use_designation,
                          'employee_class' => $employee_class,
                          'date_of_joining' => $date_of_joining,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('staff',$data_message,array('id' => $staff_id));
                    if($insert){
                        $rights =    explode(",",$access_right_ids);
             foreach($rights as $id){
                 $data_message1 = array(
                          'staff_id' => $insert,
                          'right_id' => $id,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_insert('staff_all_rights',$data_message1);
             }
                    }
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Mobile Number', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher create staff details*/
	
	/* teacher activate/deactivte staff*/
	public function teacher_activte_deactivate_staff_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($staff_id)){
            $response = array('status' => false, 'message' => 'Staff ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             if($type == "activate"){
                 $data_message = array(
                          'status' => 1,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('staff',$data_message,array('id' => $staff_id));
             }else if($type == "deactivate"){
                 $data_message = array(
                          'status' => 0,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('staff',$data_message,array('id' => $staff_id));
             }
                 
             
                
                   //   echo $this->db->last_query();exit;
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
                        
                
            }
        }
	}
	/* teacher activate/deactivte staff*/
	
	
	/* students start */
	/*generate student id start*/
	public function teacher_generate_student_id_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
              
            //         $get_all_emp = $this->user_model->common_fetch('staff',array('school_id' => $school_id));
	  //  $employee_id = 'LPIS-'.count($get_all_emp)+1;
	    
	    $get_all_emp = $this->user_model->common_fetch('students',array('school_id' => $school_id));
	    $admission_id = 'LPIS-A'.count($get_all_emp)+1;
	    
                    
                        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
                        array('admission_id' => $admission_id));
    				$this->response($response);
                  
                
                
            }
            
            
        }
	}
	/*generate student id end*/
	
	/* teacher create student details */
	public function teacher_create_student_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($admission_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_name)){
            $response = array('status' => false, 'message' => 'Student Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_dob)){
            $response = array('status' => false, 'message' => 'Student DOB Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($joining_date)){
            $response = array('status' => false, 'message' => 'Joining Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_gender)){
            $response = array('status' => false, 'message' => 'Student Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('students',array('student_name' => $student_name, 'school_id' => $school_id));
                if(empty($fetch)){
                    $image_link = '';
    			        if(!empty($student_image)){
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/students/');
        				$img = str_replace('data:image/jpeg;base64','',$student_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'class_id' => $class_id,
                          'session_id' => $session_id,
                          'admission_id' => $admission_id,
                          'joining_date' => $joining_date,
                          'student_name' => $student_name,
                          'student_dob' => $student_dob,
                          'student_gender' => $student_gender,
                          'student_blood_group' => $student_blood_group,
                          'student_image' => $image_link,
                          'caste' => $caste,
                          'religion' => $religion,
                          'nationality' => $nationality,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('students',$data_message);
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array(
                      'student_id' => $insert));
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Student Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher create student details*/
	
	/* teacher new student details update*/
	public function teacher_update_student_parent_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($father_name)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($father_mobile)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($mother_name)){
            $response = array('status' => false, 'message' => 'Student Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($mother_mobile)){
            $response = array('status' => false, 'message' => 'Student DOB Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($address)){
            $response = array('status' => false, 'message' => 'Student Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($pincode)){
            $response = array('status' => false, 'message' => 'Student Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('students',array('id' => $student_id));
                if(!empty($fetch)){
                    $image_father = '';
                    if(!empty($fetch[0]['father_image'])){
    			                $image_father = $fetch[0]['father_image'];
    			            }else{
    			                $image_father = '';
    			            }
    			            
    			        if(!empty($father_image)){
    			            
    			            if(!empty($fetch[0]['father_image'])){
    			                unlink($fetch[0]['father_image']);
    			            }
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/fathers/');
        				$img = str_replace('data:image/jpeg;base64','',$father_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_father = $user_file;
        				}
    			        }
    			        
    			        $image_mother = '';
    			        
    			        if(!empty($fetch[0]['mother_image'])){
    			                $image_mother = $fetch[0]['mother_image'];
    			            }else{
    			                $image_mother = '';
    			            }
    			            
    			        if(!empty($mother_image)){
    			            
    			            if(!empty($fetch[0]['mother_image'])){
    			                unlink($fetch[0]['mother_image']);
    			            }
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/mothers/');
        				$img = str_replace('data:image/jpeg;base64','',$mother_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_mother = $user_file;
        				}
    			        }
                     
                      $data_message = array(
                          'father_name' => $father_name,
                          'father_mobile' => $father_mobile,
                          'father_email' => $father_email,
                          'father_image' => $image_father,
                          'father_occupation' => $father_occupation,
                          'mother_name' => $mother_name,
                          'mother_mobile' => $mother_mobile,
                          'mother_email' => $mother_email,
                          'mother_image' => $image_mother,
                          'mother_occupation' => $mother_occupation,
                          'guardian_name' => $guardian_name,
                          'guardian_mobile' => $guardian_mobile,
                          'address' => $address,
                          'pincode' => $pincode,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('students',$data_message,array('id' => $student_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher new student details update*/
	public function teacher_update_student_other_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('students',array('id' => $student_id));
                if(!empty($fetch)){
                   
                     
                      $data_message = array(
                          'security_amount' => $security_amount,
                          'groups' => $groups,
                          'cabs' => $cabs,
                          'regular_medication' => $regular_medication,
                          'medicine_allergies' => $medicine_allergies,
                          'food_allergies' => $food_allergies,
                          'child_physician' => $child_physician,
                          'physician_conatct_no' => $physician_conatct_no,
                          'prefered_hosptal' => $prefered_hosptal,
                          'hospiatl_contact_no' => $hospiatl_contact_no,
                          'child_had_has' => $child_had_has,
                          'child_suffer_from' => $child_suffer_from,
                          'child_dentist' => $child_dentist,
                          'dentist_conatct_no' => $dentist_conatct_no,
                          'child_mail' => $child_mail,
                          'other_allergies' => $other_allergies,
                          'special_condition' => $special_condition,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('students',$data_message,array('id' => $student_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	
	public function teacher_view_update_student_otherised_persons_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                if($type == "view"){
                    $fetch = $this->user_model->common_fetch('student_otherised_persons',array('student_id' => $student_id));
                    if(!empty($fetch)){
                     $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array( "details" => $fetch));
    				$this->response($response);
                }    
                    
                }else{
                    $fetch = $this->user_model->common_fetch('students',array('id' => $student_id));
                if(!empty($fetch)){
                    
                    $image_father = '';
    			        if(!empty($person_image)){
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/authorised_persons/');
        				$img = str_replace('data:image/jpeg;base64','',$person_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_father = $user_file;
        				}
    			        }
                   
                     
                      $data_message = array(
                         
                          'student_id' => $student_id,
                          'person_name' => $person_name,
                          'student_relation' => $student_relation,
                          'person_image' => $image_father,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_insert('student_otherised_persons',$data_message);
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Empty Student Details', 'response' => array());
    				$this->response($response);
                }
                }
                
                        
                
            }
        }
	}
	
	/* teacher delete student*/
	public function teacher_delete_student_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Group ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('students',array('id' => $student_id));
                if(!empty($fetch)){
                    if(!empty($fetch[0]['student_image'])){
    			                unlink($fetch[0]['student_image']);
    			            }
    			     if(!empty($fetch[0]['father_image'])){
    			                unlink($fetch[0]['father_image']);
    			            }
    			     if(!empty($fetch[0]['mother_image'])){
    			                unlink($fetch[0]['mother_image']);   
    			            }
    			     if(!empty($fetch[0]['guardian_image'])){
    			                unlink($fetch[0]['guardian_image']);
    			            }
    			            $fetch_doc = $this->user_model->common_fetch('student_documents',array('student_id' => $student_id));
    			            if(!empty($fetch_doc)){
    			                foreach($fetch_doc as $doc){
    			                    unlink($doc['document']);
    			                }
    			            }
                    $delete = $this->user_model->common_permanent_delete('students',array('id' => $group_id));
                    $delete = $this->user_model->common_permanent_delete('student_documents',array('student_id' => $student_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'No Student To Delete', 'response' => (object)array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher delete student*/
	
	/* teacher view single student details */
	public function teacher_view_single_student_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Group ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->get_student_all_details($student_id);
                if(!empty($fetch)){
                  
                  $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array('student_details' =>$fetch[0]));
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'No Student To Delete', 'response' => (object)array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher view single student details */
	
	/* teacher edit student details */
	public function teacher_edit_student_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Student ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($admission_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_name)){
            $response = array('status' => false, 'message' => 'Student Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_dob)){
            $response = array('status' => false, 'message' => 'Student DOB Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($joining_date)){
            $response = array('status' => false, 'message' => 'Joining Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_gender)){
            $response = array('status' => false, 'message' => 'Student Gender Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('students',array('id' => $student_id));
                if(!empty($fetch)){
                    $image_link = '';
                    if(!empty($fetch[0]['student_image'])){
    			                $image_link = $fetch[0]['student_image'];
    			            }else{
    			                $image_link = '';
    			            }
    			        if(!empty($student_image)){
    			            if(!empty($fetch[0]['student_image'])){
    			              unlink($fetch[0]['student_image']);
    			            }
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/images/students/');
        				$img = str_replace('data:image/jpeg;base64','',$student_image);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
            				if($success){
            				    $image_link = $user_file;
            				}
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'class_id' => $class_id,
                          'session_id' => $session_id,
                          'admission_id' => $admission_id,
                          'joining_date' => $joining_date,
                          'student_name' => $student_name,
                          'student_dob' => $student_dob,
                          'student_gender' => $student_gender,
                          'student_blood_group' => $student_blood_group,
                          'student_image' => $image_link,
                          'caste' => $caste,
                          'religion' => $religion,
                          'nationality' => $nationality,
                         // 'status' => 1,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('students',$data_message,array('id' => $student_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Invalid Stdeunt ID', 'response' => (object)array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher edit student details*/
	
	
	/*students end */
	
	/*groups module start */
	
	/* teacher create new group  */
	public function teacher_create_new_group_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($group_admins)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_groups',array('group_name' => $group_name, 'school_id' => $school_id));
                if(empty($fetch)){
                    $image_link = '';
    			        if(!empty($attachment)){
    			            
    			            define('IMAGE_UPLOAD_DIR','assets/school_groups/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'group_name' => $group_name,
                          'group_description' => $group_description,
                          'group_admins' => $group_admins,
                          'group_staff' => $group_staff,
                          'group_students' => $group_students,
                          'attachment' => $image_link,
                          'group_status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_groups',$data_message);
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Group Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher create new group*/
	
	/* teacher view all groups list */
	public function teacher_view_all_groups_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $group_id = "";
                $fetch = $this->user_model->get_all_groups($school_id,$group_id);
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'groups' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view all groups list */
	
	/* teacher view single groups details */
	public function teacher_view_single_groups_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->get_all_groups($school_id,$group_id);
                $get_group_students = $this->user_model->get_group_students_details($group_id);
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $fetch[0]['students_details'] = $get_group_students;
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'groups' => $fetch[0]));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view single groups details */
	
	/* teacher update group details */
	public function teacher_update_group_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_id)){
            $response = array('status' => false, 'message' => 'Group ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($group_admins)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_groups',array('id' => $group_id));
                if(!empty($fetch)){
                    $image_link = '';
    			        if(!empty($attachment)){
    			            if(!empty($fetch[0]['attachment'])){
    			                unlink($fetch[0]['attachment']);
    			            }
    			            define('IMAGE_UPLOAD_DIR','assets/school_groups/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }else{
    			            $image_link = $fetch[0]['attachment'];
    			        }
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'group_name' => $group_name,
                          'group_description' => $group_description,
                          'group_admins' => $group_admins,
                          'group_staff' => $group_staff,
                          'group_students' => $group_students,
                          'attachment' => $image_link,
                          'group_status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_update('school_groups',$data_message,array('id' => $group_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Group Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher update group details*/
	
	/* teacher delete group details */
	public function teacher_delete_group_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($group_id)){
            $response = array('status' => false, 'message' => 'Group ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_groups',array('id' => $group_id));
                if(!empty($fetch)){
                    if(!empty($fetch[0]['attachment'])){
    			                unlink($fetch[0]['attachment']);
    			            }
                    $delete = $this->user_model->common_permanent_delete('school_groups',array('id' => $group_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Deleted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'No Group To Delete', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher delete group details*/
	
	
	/* groups module end */
	
	/* subjects  module start */
	/* teacher create new subject  */
	public function teacher_create_new_subject_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($subject_type)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($description)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_subjects',array('subject_name' => $subject_name, 'school_id' => $school_id));
                if(empty($fetch)){
                   
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'subject_name' => $subject_name,
                          'subject_type' => $subject_type,
                          'description' => $description,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_subjects',$data_message);
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Subject Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher create new subject*/
	
	/* teacher view all subjects list */
	public function teacher_view_all_subjects_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $group_id = "";
                $fetch = $this->user_model->common_fetch('school_subjects',array('school_id' => $school_id, 'delete_status' => 1));
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'subjects' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view all subjects list */
	/* teacher view single subjects data */
	public function teacher_view_single_subject_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $fetch = $this->user_model->common_fetch('school_subjects',array('id' => $subject_id));
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'subjects' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view single subjects data */
	
	/* teacher update subject  */
	public function teacher_update_subject_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($subject_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($subject_type)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($description)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('school_subjects',array('id' => $subject_id));
                if(!empty($fetch)){
                   
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'subject_name' => $subject_name,
                          'subject_type' => $subject_type,
                          'description' => $description,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('school_subjects',$data_message,array('id' => $subject_id));
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'No Subject To Update', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher update subject*/
	
	/* add teacher to subject */
	public function add_teachers_to_subjects_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($teachers)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                    $teacher_ids =  explode(",",$teachers);
                     foreach($teacher_ids as $tea){
                           $data_message = array(
                          'subject_id' => $subject_id,
                          'teacher_id' => $tea,
                         // 'subject_type' => $subject_type,
                         // 'description' => $description,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('subject_teachers',$data_message);
                     }
                    
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                        
                
            }
        }
	}
	/* add teachet to subject */
	/* subject teachers list */
	public function teacher_view_subjects_teachers_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                $group_id = "";
                $fetch = $this->user_model->get_all_subject_teachers_list($school_id,$class_id);
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'subjects' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* subject teachers list */
	
	/* update teacher to subject */
	public function update_teachers_to_subjects_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($subject_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($teachers)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                    $teacher_ids =  explode(",",$teachers);
                     foreach($teacher_ids as $tea){
                         
                          $this->user_model->common_permanent_delete('subject_teachers',array( 'subject_id' => $subject_id,'teacher_id' => $tea));
                    
                           $data_message = array(
                          'subject_id' => $subject_id,
                          'teacher_id' => $tea,
                         // 'subject_type' => $subject_type,
                         // 'description' => $description,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('subject_teachers',$data_message);
                     }
                    
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                        
                
            }
        }
	}
	/* update teachet to subject */
	
	
	/* subjects  module end */
	
	/* class  module start */
	/* teacher create new class  */
	public function teacher_create_new_class_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_teacher_ids)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('class',array('class_name' => $class_name, 'class_section' => $class_section, 
                'school_id' => $school_id, 'session_id' => $session_id));
                if(empty($fetch)){
                   
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'class_name' => $class_name,
                          'class_section' => $class_section,
                          'session_id' => $session_id,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('class',$data_message);
                    if($insert){
                       $class_teachers =  explode(",",$class_teacher_ids);
                       foreach($class_teachers as $teacher){
                        $data = array(
                            'class_id' => $insert,
                            'teacher_id' => $teacher,
                            'created_on' => date('Y-m-d H:i:s')
                            );   
                        $this->user_model->common_insert('class_teachers',$data);
                       }
                    }
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Class Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher create new class*/
	
	/* teacher view all classes list */
	public function teacher_view_all_classess_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                $fetch = $this->user_model->get_all_class_details($school_id,$type,$class_name,$class_teacher,$session_id);
                    //  echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'classes' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view all class list */
	
	/* teacher view single class details */
	public function teacher_view_single_class_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
                $fetch = $this->user_model->get_single_class_details($class_id);
                    // echo $this->db->last_query();exit;
                if(empty($fetch)){
                    $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
                }else{
                    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array(
                        'subjects' => $fetch));
    				$this->response($response);
                }
                  
                
                        
                
            }
        }
	}
	/* teacher view single class details */
	
	/* teacher update class  */
	public function teacher_update_class_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Class ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($class_teacher_ids)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                $fetch = $this->user_model->common_fetch('class',array('id' => $class_id));
                if(empty($fetch)){
                   
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'class_name' => $class_name,
                          'class_section' => $class_section,
                          'session_id' => $session_id,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('class',$data_message,array('id' => $class_id));
                    if($class_id){
                        $this->user_model->common_permanent_delete('class_teachers',array('class_id' => $class_id));
                       $class_teachers =  explode(",",$class_teacher_ids);
                       foreach($class_teachers as $teacher){
                        $data = array(
                            'class_id' => $class_id,
                            'teacher_id' => $teacher,
                            'created_on' => date('Y-m-d H:i:s')
                            );   
                        $this->user_model->common_insert('class_teachers',$data);
                       }
                    }
                   
                   //   echo $this->db->last_query();exit;
                
                  
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'Duplicate Entry Of Class Name', 'response' => array());
    				$this->response($response);
                }
                        
                
            }
        }
	}
	/* teacher update  class*/
	
	/* teacher activate/deactivte class*/
	public function teacher_activte_deactivate_class_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($class_id)){
            $response = array('status' => false, 'message' => 'Staff ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             if($type == "activate"){
                 $data_message = array(
                          'status' => 1,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('class',$data_message,array('id' => $class_id));
             }else if($type == "deactivate"){
                 $data_message = array(
                          'status' => 0,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('class',$data_message,array('id' => $class_id));
             }
                 
             
                
                   //   echo $this->db->last_query();exit;
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
                        
                
            }
        }
	}
	/* teacher activate/deactivte class*/
	
		/* teacher activate/deactivte class*/
	public function teacher_activte_deactivate_student_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($student_id)){
            $response = array('status' => false, 'message' => 'Staff ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
             if($type == "activate"){
                 $data_message = array(
                          'status' => 1,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('students',$data_message,array('id' => $student_id));
             }else if($type == "deactivate"){
                 $data_message = array(
                          'status' => 0,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $update = $this->user_model->common_update('students',$data_message,array('id' => $student_id));
             }
                 
             
                
                   //   echo $this->db->last_query();exit;
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                
                        
                
            }
        }
	}
	/* teacher activate/deactivte class*/
	
	/*create new session */
	public function create_new_session_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($session_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($start_date)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($end_date)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($active_session)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auto_create_class)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                if($active_session == "yes"){
                   $datau = array(
                       'status' => 0,
                       'updated_on' => date('Y-m-d H:i:s')
                       );
                       $this->user_model->common_update('school_sessions',$datau,array());
                      $data_message = array(
                          'school_id' => $school_id,
                          'session_name' => $session_name,
                          'start_date' => $start_date,
                          'end_date' => $end_date,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_sessions',$data_message);
                   //   echo $this->db->last_query();exit;
                
                }else if($active_session == "no"){
                     $data_message = array(
                          'school_id' => $school_id,
                          'session_name' => $session_name,
                          'start_date' => $start_date,
                          'end_date' => $end_date,
                          'status' => 1,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_sessions',$data_message);
                }
                $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
                        
                
            }
        }
	}
	/*create new session */
	
	/*all sessions list */
	public function sessions_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
               $fetch = $this->user_model->get_session_details($school_id);
               if(empty($fetch)){
                $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
               }else{
                   $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
                       'sessions' => $fetch));
    				$this->response($response);
               }     
                
            }
        }
	}
	/*all sessions list */
	/*update session name*/
	public function update_session_name_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($session_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
              
                   $datau = array(
                       'session_name' => $session_name,
                       'updated_on' => date('Y-m-d H:i:s')
                       );
                       $this->user_model->common_update('school_sessions',$datau,array('id' => $session_id));
                     
                $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                        
                
            }
        }
	}
	/*update session name*/
	
	/* session classes list*/
	public function view_session_classes_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($session_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
               $fetch = $this->user_model->common_fetch('class',array('session_id' => $session_id, 'delete_status' => 1, 'status' => 1));
               if(empty($fetch)){
                $response = array('status' => true, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
               }else{
                   $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array(
                       'classes' => $fetch));
    				$this->response($response);
               }     
                
            }
        }
	}
	/* session classes list*/
	
	/*transfer students to another class*/
	public function students_class_transfer_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($from_session_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($from_class_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($to_session_id)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($to_class_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($student_ids)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
               $students =  explode(',',$student_ids);
               foreach($students as $stu){
                   $datau = array(
                       'class_id' => $to_class_id,
                       'session_id' =>$to_session_id,
                       'updated_on' => date('Y-m-d H:i:s')
                       );
                       $this->user_model->common_update('students',$datau,array('id' => $stu));
               }
                $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
                        
                
            }
        }
	}
	/*transfer students to another class */
	
	/* teacher create new meal planner  */
	public function teacher_create_new_meal_planner_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($meal_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($meal_type)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($remarks)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                     
                      $data_message = array(
                          'school_id' => $school_id,
                          'date' => $date,
                          'meal_name' => $meal_name,
                          'meal_type' => $meal_type,
                          'remarks' => $remarks,
                          'created_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_meal_planner',$data_message);
                  $response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
               
            }
        }
	}
	/* teacher create new meal planner*/
	
	/* teacher view meal planner*/
    public function teacher_view_meal_planner_post()
    {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_teacher_meal_palnner($school_id,$date,$meal_type);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('mealplanner' => $get_planner));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
    /* teacher view  meal planner*/
    
    	/* teacher update  meal planner  */
	public function teacher_update_meal_planner_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($meal_name)){
            $response = array('status' => false, 'message' => 'Admission ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($meal_planner_id)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($remarks)){
            $response = array('status' => false, 'message' => 'Session ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                     
                      $data_message = array(
                        //   'school_id' => $school_id,
                        //   'date' => $date,
                          'meal_name' => $meal_name,
                          //'meal_type' => $meal_type,
                          'remarks' => $remarks,
                          'updated_on' =>date('Y-m-d H:i:s')
                          );
                    $insert = $this->user_model->common_insert('school_meal_planner',$data_message,array('id' => $meal_planner_id));
                  $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
               
            }
        }
	}
	/* teacher update  meal planner*/
	
	/* view all cabs list */
	public function view_all_cabs_list_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_all_cabs_list($school_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			       
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('cabs' => $get_planner));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view all cabs list */
	/* create new promotion*/
	public function create_new_promotion_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'QR Code ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachment_type)){
            $response = array('status' => false, 'message' => 'Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($attachments)){
            $response = array('status' => false, 'message' => 'Title Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($description)){
            $response = array('status' => false, 'message' => 'Description Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => '$auth_token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                     $check = $this->user_model->common_fetch('school_promotions',array('school_id' => $school_id));
                     if(empty($check)){
                         $data = array(
                        'school_id' => $school_id, 
                        'staff_id' => $teacher_id, 
                        'description' => $description,
                        'attachment_type' => $attachment_type,
                        'created_on' => date('Y-m-d H:i:s')
                        );
                    //     echo "<pre>";
                    // print_r($data);exit;
                    $insert = $this->user_model->common_insert('school_promotions',$data);
                     }else{
                         $get = $this->user_model->common_fetch('school_promotional_attachments',array('id' => $check[0]['id']));
                         if(!empty($get)){
                             foreach($get as $atta){
                                 if(!empty($atta['url'])){
                                     unlink($atta['url']);
                                 }
                             }
                         }
                         $data = array(
                        'school_id' => $school_id, 
                        'staff_id' => $teacher_id, 
                        'description' => $description,
                        'attachment_type' => $attachment_type,
                        'updated_on' => date('Y-m-d H:i:s')
                        );
                    //     echo "<pre>";
                    // print_r($data);exit;
                     $this->user_model->common_update('school_promotions',$data,array('id' => $check[0]['id']));
                     $insert = $check[0]['id'];
                     }
                     
                    if($insert){
                        	$check = $this->user_model->common_fetch('school_promotional_attachments',array('promotion_id' => $check[0]['id']));
                			
                        if(!empty($check)){
                            foreach($check as $cc){
                             unlink($cc['url']);   
                            }
                             $this->user_model->common_permanent_delete('school_promotional_attachments',array('promotion_id' => $check[0]['id']));
                			
                        }
                        if($attachment_type == "image"){
                            $images = explode(",",$attachments);
                            foreach($images as $imgsss){
                                define('IMAGE_UPLOAD_DIR','assets/albums/images/');
                				$img = str_replace('data:image/jpeg;base64','',$imgsss);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                    			    'school_id' => $school_id,
                    			    'promotion_id' => $insert,
                    			    'url' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('school_promotional_attachments',$dataimage);
                				 }
                            }
                            
                        }else if($attachment_type == "video"){
                              $videos = explode(",",$attachments);
                            foreach($videos as $vid){
                                define('IMAGE_UPLOAD_DIR','assets/albums/videos/');
                				$img = str_replace('data:video/mp4;base64','',$vid);
                				$img = str_replace(' ','+',$img);
                				$user_data = base64_decode($img);
                				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.mp4';
                				$success = file_put_contents($user_file,$user_data); 
        				
                				if($success){
                				    $image_link = $user_file;
                				    $dataimage = array(
                				    'school_id' => $school_id,
                    			    'promotion_id' => $insert,
                    			    'url' => $image_link,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->user_model->common_insert('school_promotional_attachments',$dataimage);
                				 }
                            }
                        }
                        
                    }
                    
                    $response = array('status' => true, 'message' => 'Data Added Successfully', 'response' => array());
    				$this->response($response);
                
                 }
                 
        }
	}
	/*create new promotion */
	/* view promotion details */
	public function view_promotion_details_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_promotion = $this->user_model->common_fetch('school_promotions', array('school_id' => $school_id));
    			   $get_attachments = $this->user_model->common_fetch('school_promotional_attachments', array('promotion_id' => $get_promotion[0]['id']));
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_promotion)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			       
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
    			        array('promotion' => $get_promotion, 'attachments' => $get_attachments));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* view promotion details */
	
	
	/* directory module end */
	
	/*teacher send suggesions*/
    public function teacher_sent_suggesions_post()
    {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($rating)){
            $response = array('status' => false, 'message' => 'Rating Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($remarks)){
            $response = array('status' => false, 'message' => 'Remarks Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($suggestion)){
            $response = array('status' => false, 'message' => 'Suggestion Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   
    			        $image_link = '';
    			        if(!empty($attachment)){
    			            define('IMAGE_UPLOAD_DIR','assets/staff_suggestions/');
        				$img = str_replace('data:image/jpeg;base64','',$attachment);
        				$img = str_replace(' ','+',$img);
        				$user_data = base64_decode($img);
        				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        				$success = file_put_contents($user_file,$user_data); 
				
        				if($success){
        				    $image_link = $user_file;
        				}
    			        }
    			      //  echo $user_file;
    			        $data = array(
    			            'staff_id' => $teacher_id,
    			            'rating' => $rating,
    			            'suggestion' => $suggestion,
    			            'remarks' => $remarks,
    			            'attachment' => $image_link,
    			            'date'  => date('Y-m-d H:i:s'),
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			           // print_r($data);
    			            //exit;
    			   
    			    $insert = $this->user_model->common_insert('staff_suggestions',$data);
    			    
    			    
    				$response = array('status' => true, 'message' => 'Data Inserted Successfully', 'response' => array());
    				$this->response($response);
    			
            }
			
		}
	}
    /*teacher send suggesions*/
    
     /*teacher view about us details */
    public function teacher_view_about_us_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_teacher_school_aboutus($school_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('aboutus' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*teacher view about us details */
	/*teacher view terms and conditions details */
    public function teacher_view_terms_and_conditions_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_teacher_school_terms_condition($school_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('termsandconditions' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*teacher view terms and conditions details */
	/*teacher view privacy policy details */
    public function teacher_view_privacy_policy_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			   $get_planner = $this->user_model->get_teacher_school_privacy_policy($school_id);
    			//  echo $this->db->last_query();exit;
    			    if(empty($get_planner)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => array());
    				$this->response($response);
    			    }else{
    			        $check = $this->user_model->common_fetch('parent_logins',array('parent_mobile' => $mobile));
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => array('privacypolicy' => $get_planner,
    				'parent' =>$check));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/*teacher view privacy policy details */
	
	/* teacher view staff attendance */
	public function teacher_view_staff_attendance_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($attendance_type)){
            $response = array('status' => false, 'message' => 'Attendance Type Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			if($attendance_type == "marked"){
    			    $attendace = $this->user_model->get_staff_marked_attendance_details($school_id,$teacher_id,$date);
    			}else if($attendance_type == "not_marked"){
    			    $attendace = $this->user_model->get_staff_notmarked_attendance_details($school_id,$teacher_id,$date);
    			}
    			  
    		//	  echo $this->db->last_query();exit;
    			    if(empty($attendace)){
    			        $response = array('status' => false, 'message' => 'Empty Data', 'response' => (object)array());
    				$this->response($response);
    			    }else{
    			        
    			        $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' => 
    			        array('attendance' => $attendace));
    				$this->response($response);
    			    }
    				
    			
            }
			
		}
	}
	/* teacher view staff attendance */
	
	/*teacher share report*/
	public function teacher_share_attendance_report_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($teacher_id)){
            $response = array('status' => false, 'message' => 'Teacher ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($school_id)){
            $response = array('status' => false, 'message' => 'School ID Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($from_date)){
            $response = array('status' => false, 'message' => 'From Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($to_date)){
            $response = array('status' => false, 'message' => 'To Date Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($email)){
            $response = array('status' => false, 'message' => 'Email Is Empty', 'response' => array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('staff',array('id' => $teacher_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			  
    	
    			 //   $this->load->config('email');
        // $this->load->library('email');
        //     $from = 'sagarnalluri22@gmail.com';
        //     $to = 'sagarnalluri22@gmail.com';
        //     $subject = 'test';
        //     $message = 'test';
        //      $this->email->set_newline("\r\n");
        // $this->email->from($from);
        // $this->email->to($to);
        // $this->email->subject($subject);
        // $this->email->message($message);

        // if ($this->email->send()) {
        //     echo 'Your Email has successfully been sent.';
        // } else {
        //     show_error($this->email->print_debugger());
        // }
             
        //     echo $this->email->print_debugger();
        //     exit;
            $response = array('status' => true, 'message' => 'Email Sent Successfully', 'response' => $mail);
                   $this->response($response);
    				
    			
            }
			
		}
	}
	/*teacher share report*/
	
	
	/*---------------------teacher apis end ---------------------------------*/
	
	












      /*add report new joining/resignation*/
    
		
	

		
		/*about us api*/
	public function about_us_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    $about_us = $this->user_model->common_fetch('about_us',array('delete_status' => '1'));
	    $response = array('status' => true, 'message' => 'About Us Page Content', 'response' => $about_us);
				$this->response($response);
	}
		/*about us api*/
		
			/*privacy policy api*/
	public function privacy_policy_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    $privacy_policy = $this->user_model->common_fetch('privacy_policy',array('delete_status' => '1'));
	    $response = array('status' => true, 'message' => 'Privacy Policy Page Content', 'response' => $privacy_policy);
				$this->response($response);
	}
		/*privacy policy api*/
		
		/*terms & conditions api*/
	public function terms_and_conditions_get()
	{
	    //$user_input = $this->client_request;
	    //extract($user_input);
	    $terms_and_conditions = $this->user_model->common_fetch('terms_and_conditions',array('delete_status' => '1'));
	    $response = array('status' => true, 'message' => 'Terms And Conditions Page Content', 'response' => $terms_and_conditions);
				$this->response($response);
	}
		/*terms & conditions api*/
		
   /*-------------training manager apis-----------------------*/
   
   /*add new training schedule*/
   public function view_training_manager_day_schedule_post()
   {
       $user_input = $this->client_request;
	    extract($user_input);
	    if(empty($employee_id)){
	        $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
	        	$this->response($response);
	    }else if(empty($date)){
            $response = array('status' => false, 'message' => 'Date Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            
             $check_user = $this->user_model->common_fetch('employees',array('id' => $employee_id));
           // print_r($check_user);exit;
         //  echo $check_user[0]['auth_token'].$auth_token;exit;
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else{
                
                $get_schedule = $this->user_model->get_training_manager_schedule($employee_id,$date);
                 //  print_r($details);exit;
                    $details['week_date'] = date('d F, l', $date1);
                     $details['date'] = date('Y-m-d', $date1);
                     $details['day_schedule'] = $get_schedule;
                
                $response = array('status' => true, 'message' => 'Training Manager Day Schedule', 'response' => $details);
				$this->response($response);
                     
                
            }
        }
   }

   
   /*weekly schedule*/
   public function view_weekly_schedule_post()
   {
       $user_input = $this->client_request;
	    extract($user_input);
	    if(empty($employee_id)){
	        $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
	        	$this->response($response);
	    }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            
             $check_user = $this->user_model->common_fetch('employees',array('id' => $employee_id));
           // print_r($check_user);exit;
         //  echo $check_user[0]['auth_token'].$auth_token;exit;
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else{
                
                
	        $weekdays = [];
	        $weekdates = [];
	               // $sales['from_date'] = $date = date('d M Y', strtotime("this week"));
	                //$date = strtotime("+6 day", strtotime($date));
                //   $sales['to_date'] = date('M d, Y', $date);
                //     $sales['to_date'] = date('d M Y');
                    
                //     $date = strtotime("+7 day");
                // $date = strtotime("+6 day", strtotime($date));
                //   $sales['to_date'] = date('M d, Y', $date);
                   $date = date('d M Y', strtotime("this week"));
                   for($i =0; $i <= 6; $i++){
                       
                       $date1 = strtotime("+".$i." day", strtotime($date));
                   $weekdays[$i]  = $day_new = date('d F, l', $date1);
                   $weekdates[$i] = $date_today =  date('Y-m-d', $date1);
                 //  $get_schedule = $this->user_model->common_fetch('training_manager_schedule',array('employee_id' => $employee_id,'date' => $date_today));
                    $get_schedule = $this->user_model->get_training_manager_schedule($employee_id,$date_today);
                 //  print_r($details);exit;
                    $details[$i]['week_date'] = date('d F, l', $date1);
                     $details[$i]['date'] = date('Y-m-d', $date1);
                    if(!empty($get_schedule)){
                         $details[$i]['week_schedule'] = $get_schedule;
                    }else{
                        $details[$i]['week_schedule'] = [];
                    }
                  
               //   echo $this->db->last_query();exit;
                   }
                    
                   //print_r($details);exit;
                   $response = array('status' => true, 'message' => 'Training Manager Weekly Schedule', 'response' => $details);
				$this->response($response);
                    
                    //   $date = date('d M Y', strtotime("this week")); //today date
                    //      $weekOfdays = array();
                    //       for($i =0; $i <= 6; $i++){
                    //             $date = date('Y-m-d', strtotime('+'.$i.' day', strtotime($date)));
                    //           $weekOfdays[] = date(''.$i.' : Y-m-d', strtotime($date));
                    //           $i++;
                    //             }
                    //               print_r($weekOfdays);exit;

           }
	    }
   }
   /*weekly schedule*/
   
   /*monthly schedule*/
   public function view_monthly_schedule_post()
   {
       $user_input = $this->client_request;
	    extract($user_input);
	    if(empty($employee_id)){
	        $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
	        	$this->response($response);
	    }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
             $check_user = $this->user_model->common_fetch('employees',array('id' => $employee_id));
           // print_r($check_user);exit;
         //  echo $check_user[0]['auth_token'].$auth_token;exit;
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => (object)array());
                $this->response($response);
            }else{
            
	        $monthdays = [];
	        //$weekdates = [];
	        
	        $list=array();
            $month = date('m');
            $year = date('Y');
            
            for($d=0; $d<=30; $d++)
            {
                $time=mktime(12, 0, 0, $month, $d, $year);          
                if (date('m', $time)==$month)       
                    $list[]=date('d F, l', $time);
                     $get_schedule = $this->user_model->get_training_manager_schedule($employee_id,date('Y-m-d', $time));
                    // $get_schedule = $this->user_model->common_fetch('training_manager_schedule',array('employee_id' => $employee_id,'date' => date('Y-m-d', $time)));
                 //  print_r($details);exit;
                    $details[$d]['month_date'] = date('d F, l', $time);
                    $details[$d]['date'] = date('Y-m-d', $time);
                    if(!empty($get_schedule)){
                         $details[$d]['month_schedule'] = $get_schedule;
                    }else{
                        $details[$d]['month_schedule'] = [];
                    }
            }
            // echo "<pre>";
            // print_r($details);
            // echo "</pre>";
            
             $response = array('status' => true, 'message' => 'Training Manager Monthly Schedule', 'response' => $details);
				$this->response($response);

            }
	    }
   }
   /*monthly schedule*/
   

   
   /*-------------training manager apis-----------------------*/
   
  
     
     
    
     
     
   
     
     
   
     
     
     /*----- notifications api ----*/
     
     public function notifications_post()
     {
         $user_input = $this->client_request;
         extract($user_input);
         if(empty($employee_id)){
             $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => array());
             $this->response($response);
         }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            
            $check_user = $this->user_model->common_fetch('employees',array('id' => $employee_id));
           // print_r($check_user);exit;
         //  echo $check_user[0]['auth_token'].$auth_token;exit;
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
                
                
           //  $get_notiifcations = $this->user_model->common_fetch('notifications',array('employee_id' => $employee_id));
             $get_notiifcations = $this->user_model->get_employye_notification($employee_id);
            
             if(empty($get_notiifcations)){
                
                 $response = array('status' => false, 'message' => 'No Data', 'response' => array());
                 $this->response($response);
                 
             }else{
                  $date = '';
                 $data = [];
                 $i = 0;
                  foreach($get_notiifcations as $row){
                      $date = date('d-m-Y',strtotime($row['date']));
                      $row['date'] = $date;
                      $data[$i] =  $row;
                      $i++;
                  }
                 $response = array('status' => true, 'message' => 'Data Fetched Successfully', 'response' =>$data);
                 $this->response($response);
                 
             }
             
            }
         }
     }
     /*notifications api */
     public function check_employee_site_location_post()
     {
         $user_input = $this->client_request;
         extract($user_input);
         if(empty($employee_id)){
             $response = array('status' => false, 'message' => 'Employee ID Is Empty', 'response' => (object)array());
             $this->response($response);
         }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($site_id)){
            $response = array('status' => false, 'message' => 'Site ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($latitude)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($longitude)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
            
            $get_distance = $this->user_model->get_employee_site_distance($site_id,$latitude,$longitude);
            // echo "<pre>";
            // print_r($get_distance);exit;
            if(!empty($get_distance)){
                if($get_distance[0]->distance <= 100){
                    $response = array('status' => true, 'message' => 'Near site location', 'response' =>(object)array());
                 $this->response($response);
                    
                }else{
                    $response = array('status' => false, 'message' => 'You are not in site location', 'response' => (object)array());
                 $this->response($response);
                }
                
            }else{
                 $response = array('status' => false, 'message' => 'You are not in site location', 'response' => (object)array());
                 $this->response($response);
            }
        
            
        }
     }
     public function send_mail_get()
     {
           $this->load->config('email');
        $this->load->library('email');
            
            // $config['protocol']    = 'smtp';
            // $config['smtp_host']    = 'ssl://smtp.gmail.com';
            // $config['smtp_port']    = '465';
            // $config['smtp_timeout'] = '7';
            // $config['smtp_user']    = 'sagarnalluri22@gmail.com';
            // $config['smtp_pass']    = '';
            // $config['charset']    = 'utf-8';
            // $config['newline']    = "\r\n";
            // $config['mailtype'] = 'text'; // or html
            // $config['validation'] = TRUE; // bool whether to validate email or not      
            
            // $this->email->initialize($config);
            
            // $this->email->from('sagarnalluri22@gmail.com', 'sender_name');
            // $this->email->to('sagarnalluri22@gmail.com'); 
            // $this->email->subject('Email Test');
            // $this->email->message('Testing the email class.');  
            
            // $this->email->send();
           // $this->email->initialize($config);
            $from = 'sagarnalluri22@gmail.com';
            $to = 'sagarnalluri22@gmail.com';
            $subject = 'test';
            $message = 'test';
             $this->email->set_newline("\r\n");
        $this->email->from($from);
        $this->email->to($to);
        $this->email->subject($subject);
        $this->email->message($message);

        if ($this->email->send()) {
            echo 'Your Email has successfully been sent.';
        } else {
            show_error($this->email->print_debugger());
        }
             
            echo $this->email->print_debugger();
            exit;
            $response = array('status' => true, 'message' => 'Email Sent Successfully', 'response' => $mail);
                   $this->response($response);
            
     }

}

?>