<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->is_logged_in();
		$this->load->model('mainmodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")');
		date_default_timezone_set("Asia/Kolkata");
	}


	public function index()
	{
		$this->load->view('includes/admin_header');
		$this->load->view('list_schools');
		$this->load->view('includes/footer');
	}
	public function is_logged_in()
	{
		$is_logged_in = $this->session->userdata('is_logged_in');
		$role = $this->session->userdata('role');
		if(!isset($is_logged_in) || $is_logged_in != true )
		{
			//|| $role != "superadmin"
			redirect('/', 'refresh');
		}
	}
	
	function is_logged_out()
    {
        $this->session->unset_userdata('is_logged_in');
        redirect('/', 'refresh');
	}
	
	function add_school()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('add_school');
		$this->load->view('includes/footer');
	}
	function schools_list()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('list_schools');
		$this->load->view('includes/footer');
	}
	function all_schools_info()
	{
	    $categories = $this->mainmodel->get_all_details_school($_POST);
        $result_count=$this->mainmodel->get_all_details_school($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	function add_school_details()
	{
	    $name = $this->input->post('name');
	    $area = $this->input->post('area');
	    $username = $this->input->post('username');
	    $password = md5($this->input->post('password'));
	   // echo $name.$area.$username.$password;exit;
	    if(!empty($name) && !empty($area) && !empty($username) && !empty($password)){
	        $checkschool  = $this->mainmodel->common_fetch('schools',array('school_name' => $name)); 
	        $checkschoollogin = $this->mainmodel->common_fetch('school_logins',array('username' => $username)); 
	        if(empty($checkschool) && empty($checkschoollogin)){
	            $data = array(
	                'school_name' =>$name,
	                'school_area' => $area,
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('schools',$data);
	           if($insert){
	               $data1 = array(
	                   'school_id' => $insert,
	                   'username' => $username,
	                   'password' => $password,
	                   'status' => 1,
	                   'created_on' => date('Y-m-d H:i:s')
	                   );
	                   $insertlogin = $this->mainmodel->common_insert('school_logins',$data1);
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "School details added successfully."
        	            );
	                   
	           }
	            
	        }else if(!empty($checkschool)){
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry school name with same name already exists."
	            );
	        }else if(!empty($checkschoollogin)){
	            $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry of username.Please add new username with unique name."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	    
	}
	function update_school_user_status()
	{
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	      
	    
	    if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("school_logins",$data,array('school_id' => $id));
	      // echo      $update_area;exit;
	    echo json_encode($update_area);
				exit;
	    }
	}
	

}//end of page
